/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.ml.core.dataset.DatasetDeriver;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class SimpleRandomSampling<D extends IDataset<?>>
extends ASamplingAlgorithm<D> {
    private Random random;
    private Collection<Integer> chosenIndices;
    private boolean isLargeSample;
    private int numberOfLastSample = 0;

    public SimpleRandomSampling(Random random, D input) {
        super(input);
        this.random = random;
    }

    public IAlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        int n = ((IDataset)this.getInput()).size();
        switch (this.getState()) {
            case CREATED: {
                this.isLargeSample = (double)this.sampleSize * 1.0 / (double)n > 0.3;
                return this.activate();
            }
            case ACTIVE: {
                int i;
                if (this.isLargeSample) {
                    this.chosenIndices = new ArrayList<Integer>(n);
                    for (i = 0; i < n; ++i) {
                        if (i % 100 == 0) {
                            this.checkAndConductTermination();
                        }
                        this.chosenIndices.add(i);
                    }
                    Collections.shuffle((List)this.chosenIndices, this.random);
                    this.chosenIndices = ((List)this.chosenIndices).subList(0, this.sampleSize);
                } else {
                    this.chosenIndices = new HashSet<Integer>();
                    while (this.numberOfLastSample < this.sampleSize) {
                        if (this.numberOfLastSample % 100 == 0) {
                            this.checkAndConductTermination();
                        }
                        while (this.chosenIndices.contains(i = this.random.nextInt(this.sampleSize))) {
                        }
                        this.chosenIndices.add(i);
                        ++this.numberOfLastSample;
                    }
                }
                DatasetDeriver<IDataset> deriver = new DatasetDeriver<IDataset>((IDataset)this.getInput());
                deriver.addIndices(this.chosenIndices);
                try {
                    this.sample = deriver.build();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not create sample.", (Throwable)e);
                }
                if (this.chosenIndices == null) {
                    throw new IllegalStateException("Chosen indices must not be null!");
                }
                return this.terminate();
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }

    public Collection<Integer> getChosenIndices() {
        if (this.chosenIndices == null) {
            throw new IllegalStateException("The algorithm has not run, so no indices have been chosen!");
        }
        return Collections.unmodifiableCollection(this.chosenIndices);
    }
}

