/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories;

import ai.libs.jaicore.basic.reconstruction.ReconstructionInstruction;
import ai.libs.jaicore.basic.reconstruction.ReconstructionPlan;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.common.reconstruction.IReconstructible;
import org.api4.java.common.reconstruction.IReconstructionInstruction;
import org.api4.java.common.reconstruction.IReconstructionPlan;

public abstract class ASampleAlgorithmFactory<D extends IDataset<?>, A extends ASamplingAlgorithm<D>>
implements ISamplingAlgorithmFactory<D, A>,
IReconstructible {
    private int sampleSize;
    private long seed;
    private Random random;

    public static <D extends IDataset<?>, A extends ASamplingAlgorithm<D>, T extends ASampleAlgorithmFactory<D, A>> T create(Class<T> factoryClazz, int sampleSize, long seed) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ASampleAlgorithmFactory factory = (ASampleAlgorithmFactory)factoryClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        factory.setRandom(new Random(seed));
        factory.setSampleSize(sampleSize);
        return (T)factory;
    }

    protected ReconstructionInstruction getConstructionInstruction() {
        return new ReconstructionInstruction(ASampleAlgorithmFactory.class.getName(), "create", new Class[]{Class.class, Integer.TYPE, Long.TYPE}, new Object[]{this.getClass(), this.sampleSize, this.seed});
    }

    public IReconstructionPlan getConstructionPlan() {
        return new ReconstructionPlan(Arrays.asList(this.getConstructionInstruction()));
    }

    public void addInstruction(IReconstructionInstruction instruction) {
        throw new UnsupportedOperationException("No instructions can be added to a sampling factory.");
    }

    @Override
    public A getAlgorithm(D inputDataset) {
        Objects.requireNonNull(this.random);
        if (this.sampleSize == 0 || this.sampleSize > inputDataset.size()) {
            throw new IllegalStateException("Illegal sample size " + this.sampleSize + " for dataset with " + inputDataset.size() + " points.");
        }
        return this.getAlgorithm(this.sampleSize, inputDataset, this.random);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
        this.seed = -1L;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }
}

