/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.client;

import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.client.ExtrapolationRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ExtrapolationServiceClient<C> {
    private String serviceUrl;
    private Class<C> configClass;

    public ExtrapolationServiceClient(String serviceUrl, Class<C> configClass) {
        this.serviceUrl = serviceUrl;
        this.configClass = configClass;
    }

    public C getConfigForAnchorPoints(int[] xValuesArr, double[] yValuesArr) throws InvalidAnchorPointsException, InterruptedException, ExecutionException {
        ExtrapolationRequest request = new ExtrapolationRequest();
        ArrayList<Integer> xValues = new ArrayList<Integer>();
        for (int x : xValuesArr) {
            xValues.add(x);
        }
        ArrayList<Double> yValues = new ArrayList<Double>();
        for (double y : yValuesArr) {
            yValues.add(y);
        }
        request.setxValues(xValues);
        request.setyValues(yValues);
        Client client = ClientBuilder.newClient();
        WebTarget target = null;
        try {
            target = client.target(new URI(this.serviceUrl));
        }
        catch (Exception e) {
            throw new IllegalStateException("No WebTarget!", e);
        }
        Future future = target.request(new String[]{"application/json"}).async().post(Entity.entity((Object)request, (String)"application/json"));
        Response response = (Response)future.get();
        if (response.getStatus() == 500 && ((String)response.readEntity(String.class)).equals("Invalid anchorpoints")) {
            throw new InvalidAnchorPointsException();
        }
        return (C)response.readEntity(this.configClass);
    }
}

