/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.pdm.dataset;

import ai.libs.jaicore.basic.sets.Pair;
import java.util.ArrayList;
import java.util.List;

public class SensorTimeSeries {
    private List<Pair<Integer, Double>> timestepValuePairs = new ArrayList<Pair<Integer, Double>>();

    public void addValue(int timestep, double value) {
        this.timestepValuePairs.add((Pair<Integer, Double>)new Pair((Object)timestep, (Object)value));
    }

    public Double getValueOrNull(int timestep) {
        for (int i = 0; i < this.timestepValuePairs.size(); ++i) {
            if (!((Integer)this.timestepValuePairs.get(i).getX()).equals(timestep)) continue;
            return (Double)this.timestepValuePairs.get(i).getY();
        }
        return null;
    }

    public SensorTimeSeries getWindowedTimeSeries(int fromTimestep, int toTimestep) {
        SensorTimeSeries newSensorTimeSeries = new SensorTimeSeries();
        for (int t = 0; t < this.timestepValuePairs.size(); ++t) {
            if (fromTimestep > (Integer)this.timestepValuePairs.get(t).getX() || (Integer)this.timestepValuePairs.get(t).getX() >= toTimestep) continue;
            newSensorTimeSeries.addValue((Integer)this.timestepValuePairs.get(t).getX(), (Double)this.timestepValuePairs.get(t).getY());
        }
        return newSensorTimeSeries;
    }

    public int getLength() {
        return (Integer)this.timestepValuePairs.get(this.timestepValuePairs.size() - 1).getX();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.timestepValuePairs == null ? 0 : this.timestepValuePairs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensorTimeSeries other = (SensorTimeSeries)obj;
        return !(this.timestepValuePairs == null ? other.timestepValuePairs != null : !this.timestepValuePairs.equals(other.timestepValuePairs));
    }

    public String toString() {
        return "SensorTimeSeries [timestepValuePairs=" + this.timestepValuePairs + "]";
    }
}

