/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.pdm.dataset;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.AGenericObjectAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.NumericAttribute;
import ai.libs.jaicore.ml.pdm.dataset.SensorTimeSeries;
import ai.libs.jaicore.ml.pdm.dataset.SensorTimeSeriesAttributeValue;
import java.util.StringJoiner;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttributeValue;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IObjectAttribute;

public class SensorTimeSeriesAttribute
extends AGenericObjectAttribute<SensorTimeSeries>
implements IObjectAttribute<NumericAttribute> {
    private static final long serialVersionUID = 7375915385236514621L;
    private static final String SENSOR_TIME_SERIES_BORDER_FLAG = "\"";
    private static final String EMPTY_STRING = "";
    private static final String DATA_POINT_SEPARATOR = " ";
    private static final String SPLIT_MULTIPLE_WHITESPACES = "\\s+";
    private static final String TIMESTEP_VALUE_SEPARATOR = "#";

    public SensorTimeSeriesAttribute(String name) {
        super(name);
    }

    public boolean isValidValue(Object value) {
        return value instanceof SensorTimeSeries;
    }

    public String getStringDescriptionOfDomain() {
        return "[TS] " + this.getName();
    }

    public IAttributeValue getAsAttributeValue(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof SensorTimeSeriesAttributeValue) {
                return new SensorTimeSeriesAttributeValue(this, ((SensorTimeSeriesAttributeValue)object).getValue());
            }
            return new SensorTimeSeriesAttributeValue(this, (SensorTimeSeries)object);
        }
        throw new IllegalArgumentException("No valid value for this attribute");
    }

    public double toDouble(Object object) {
        throw new UnsupportedOperationException("Not yet implemented in SensorTimeSeriesAttribute");
    }

    public String serializeAttributeValue(Object value) {
        StringJoiner sj = new StringJoiner(DATA_POINT_SEPARATOR);
        SensorTimeSeries sensorTimeSeries = (SensorTimeSeries)value;
        for (int t = 0; t <= sensorTimeSeries.getLength(); ++t) {
            if (sensorTimeSeries.getValueOrNull(t) == null) continue;
            sj.add(t + TIMESTEP_VALUE_SEPARATOR + sensorTimeSeries.getValueOrNull(t));
        }
        return SENSOR_TIME_SERIES_BORDER_FLAG + sj.toString() + SENSOR_TIME_SERIES_BORDER_FLAG;
    }

    public Object deserializeAttributeValue(String string) {
        string = string.replace(SENSOR_TIME_SERIES_BORDER_FLAG, EMPTY_STRING);
        String[] splittedString = string.split(SPLIT_MULTIPLE_WHITESPACES);
        SensorTimeSeries sensorTimeSeries = new SensorTimeSeries();
        for (int i = 0; i < splittedString.length; ++i) {
            String[] dataPoint = splittedString[i].split(TIMESTEP_VALUE_SEPARATOR);
            sensorTimeSeries.addValue(Integer.parseInt(dataPoint[0]), Double.parseDouble(dataPoint[1]));
        }
        return sensorTimeSeries;
    }

    @Override
    protected SensorTimeSeries getValueAsTypeInstance(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof SensorTimeSeriesAttributeValue) {
                return ((SensorTimeSeriesAttributeValue)object).getValue();
            }
            return (SensorTimeSeries)object;
        }
        throw new IllegalArgumentException("No valid value for this attribute");
    }
}

