/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.util;

import ai.libs.jaicore.ml.ranking.dyad.learner.util.AbstractDyadScaler;
import java.util.List;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.common.math.IVector;

public class DyadStandardScaler
extends AbstractDyadScaler {
    private static final long serialVersionUID = 1L;

    @Override
    public void transformInstances(IDyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getContext().length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = dyad.getContext().getValue(i);
            value -= this.statsX[i].getMean();
            if (this.statsX[i].getStandardDeviation() != 0.0) {
                value /= this.statsX[i].getStandardDeviation();
            }
            dyad.getContext().setValue(i, value);
        }
    }

    @Override
    public void transformAlternatives(IDyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getAlternative().length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = dyad.getAlternative().getValue(i);
            value -= this.statsY[i].getMean();
            if (this.statsY[i].getStandardDeviation() != 0.0) {
                value /= this.statsY[i].getStandardDeviation();
            }
            dyad.getAlternative().setValue(i, value);
        }
    }

    @Override
    public void transformInstaceVector(IVector vector, List<Integer> ignoredIndices) {
        for (int i = 0; i < vector.length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = vector.getValue(i);
            value -= this.statsX[i].getMean();
            if (this.statsX[i].getStandardDeviation() != 0.0) {
                value /= this.statsX[i].getStandardDeviation();
            }
            vector.setValue(i, value);
        }
    }
}

