/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.util;

import ai.libs.jaicore.ml.ranking.dyad.learner.util.AbstractDyadScaler;
import java.util.List;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingDataset;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingInstance;
import org.api4.java.common.math.IVector;

public class DyadUnitIntervalScaler
extends AbstractDyadScaler {
    private double[] lengthOfX;
    private double[] lengthOfY;
    private static final long serialVersionUID = -6732663643697649308L;

    @Override
    public void fit(IDyadRankingDataset dataset) {
        super.fit(dataset);
        int lengthX = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getContext().length();
        this.lengthOfX = new double[lengthX];
        for (int i = 0; i < lengthX; ++i) {
            this.lengthOfX[i] = Math.sqrt(this.statsX[i].getSumsq());
        }
        int lengthY = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getAlternative().length();
        this.lengthOfY = new double[lengthY];
        for (int i = 0; i < lengthY; ++i) {
            this.lengthOfY[i] = Math.sqrt(this.statsY[i].getSumsq());
        }
    }

    @Override
    public void transformInstances(IDyadRankingDataset dataset, List<Integer> ignoredIndices) {
        int lengthX = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getContext().length();
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                for (int i = 0; i < lengthX; ++i) {
                    double value = dyad.getContext().getValue(i);
                    if (value != 0.0) {
                        value /= this.lengthOfX[i];
                    }
                    dyad.getContext().setValue(i, value);
                }
            }
        }
    }

    @Override
    public void transformAlternatives(IDyadRankingDataset dataset, List<Integer> ignoredIndices) {
        int lengthY = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getAlternative().length();
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                for (int i = 0; i < lengthY; ++i) {
                    double value = dyad.getAlternative().getValue(i);
                    if (value != 0.0) {
                        value /= this.lengthOfY[i];
                    }
                    dyad.getAlternative().setValue(i, value);
                }
            }
        }
    }

    @Override
    public void transformInstaceVector(IVector vector, List<Integer> ignoredIndices) {
        for (int i = 0; i < vector.length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = vector.getValue(i);
            if (value != 0.0) {
                value /= Math.sqrt(this.statsX[i].getSumsq());
            }
            vector.setValue(i, value);
        }
    }

    @Override
    public void transformInstances(IDyad dyad, List<Integer> ignoredIndices) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public void transformAlternatives(IDyad dyad, List<Integer> ignoredIndices) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

