/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss;

import ai.libs.jaicore.ml.regression.loss.dataset.MeanAbsoluteError;
import ai.libs.jaicore.ml.regression.loss.dataset.MeanAbsolutePercentageError;
import ai.libs.jaicore.ml.regression.loss.dataset.MeanSquaredError;
import ai.libs.jaicore.ml.regression.loss.dataset.R2;
import ai.libs.jaicore.ml.regression.loss.dataset.RootMeanSquaredError;
import ai.libs.jaicore.ml.regression.loss.dataset.RootMeanSquaredLogarithmError;
import java.util.List;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public enum ERegressionPerformanceMeasure implements IDeterministicPredictionPerformanceMeasure<Double, IRegressionPrediction>
{
    MSE(new MeanSquaredError()),
    RMSE(new RootMeanSquaredError()),
    RMSLE(new RootMeanSquaredLogarithmError()),
    MAE(new MeanAbsoluteError()),
    MAPE(new MeanAbsolutePercentageError()),
    R2(new R2());

    private final IDeterministicPredictionPerformanceMeasure<Double, IRegressionPrediction> measure;

    private ERegressionPerformanceMeasure(IDeterministicPredictionPerformanceMeasure<Double, IRegressionPrediction> measure) {
        this.measure = measure;
    }

    public double loss(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        return this.measure.loss(expected, predicted);
    }

    public double score(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        return this.measure.score(expected, predicted);
    }

    public double loss(IPredictionAndGroundTruthTable<? extends Double, ? extends IRegressionPrediction> pairTable) {
        return this.measure.loss(pairTable);
    }

    public double score(IPredictionAndGroundTruthTable<? extends Double, ? extends IRegressionPrediction> pairTable) {
        return this.measure.score(pairTable);
    }
}

