/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.ml.regression.loss.dataset.ARegressionMeasure;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class AsymmetricLoss
extends ARegressionMeasure {
    private double dividerOverestimation = 5.0;
    private double dividerUnderestimation = 20.0;

    public AsymmetricLoss() {
    }

    public AsymmetricLoss(double dividerUnderestimation, double dividerOverestimation) {
        this.dividerOverestimation = dividerUnderestimation;
        this.dividerUnderestimation = dividerOverestimation;
    }

    @Override
    public double loss(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        this.checkConsistency(expected, predicted);
        ArrayList<Double> accuracyList = new ArrayList<Double>();
        for (int i = 0; i < expected.size(); ++i) {
            Double percentageError = 100.0 * ((expected.get(i) - predicted.get(i).getPrediction()) / expected.get(i));
            Double accuracy = percentageError <= 0.0 ? Double.valueOf(Math.exp(-Math.log(0.5) * (percentageError / this.dividerOverestimation))) : Double.valueOf(Math.exp(Math.log(0.5) * (percentageError / this.dividerUnderestimation)));
            accuracyList.add(accuracy);
        }
        return 1.0 - StatisticsUtil.mean(accuracyList);
    }
}

