/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.ml.regression.loss.dataset.ARegressionMeasure;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class AsymmetricLoss2
extends ARegressionMeasure {
    private double dividerUnderestimation = 10.0;
    private double dividerOverestimation = 13.0;

    public AsymmetricLoss2() {
    }

    public AsymmetricLoss2(double dividerUnderestimation, double dividerOverestimation) {
        this.dividerUnderestimation = dividerUnderestimation;
        this.dividerOverestimation = dividerOverestimation;
    }

    @Override
    public double score(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        this.checkConsistency(expected, predicted);
        double loss = 0.0;
        for (int i = 0; i < expected.size(); ++i) {
            Double difference = predicted.get(i).getPrediction() - expected.get(i);
            if (difference < 0.0) {
                loss += Math.exp(-(difference / this.dividerUnderestimation)) - 1.0;
                continue;
            }
            loss += Math.exp(difference / this.dividerOverestimation) - 1.0;
        }
        return loss;
    }
}

