/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.ml.regression.loss.dataset.ARegressionMeasure;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class MeanAsymmetricLoss2
extends ARegressionMeasure {
    private double dividerUnderestimation = 10.0;
    private double dividerOverestimation = 13.0;

    public MeanAsymmetricLoss2() {
    }

    public MeanAsymmetricLoss2(double dividerUnderestimation, double dividerOverestimation) {
        this.dividerUnderestimation = dividerUnderestimation;
        this.dividerOverestimation = dividerOverestimation;
    }

    @Override
    public double score(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        this.checkConsistency(expected, predicted);
        ArrayList<Double> losses = new ArrayList<Double>();
        for (int i = 0; i < expected.size(); ++i) {
            Double difference = predicted.get(i).getPrediction() - expected.get(i);
            double loss = difference < 0.0 ? Math.exp(-(difference / this.dividerUnderestimation)) - 1.0 : Math.exp(difference / this.dividerOverestimation) - 1.0;
            losses.add(loss);
        }
        return StatisticsUtil.mean(losses);
    }
}

