/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.ml.regression.loss.dataset.AUnboundedRegressionMeasure;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class QuadraticQuadraticError
extends AUnboundedRegressionMeasure {
    private double weightUnderestimation = 1.0;

    public QuadraticQuadraticError() {
    }

    public QuadraticQuadraticError(double weightUnderestimation) {
        this.weightUnderestimation = weightUnderestimation;
    }

    @Override
    public double loss(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        ArrayList<Double> errors = new ArrayList<Double>();
        for (int i = 0; i < expected.size(); ++i) {
            double difference = predicted.get(i).getPrediction() - expected.get(i);
            Double error = difference <= 0.0 ? Double.valueOf(2.0 * this.weightUnderestimation * Math.pow(difference, 2.0)) : Double.valueOf(2.0 * (this.weightUnderestimation + (1.0 - 2.0 * this.weightUnderestimation)) * Math.pow(difference, 2.0));
            errors.add(error);
        }
        return StatisticsUtil.mean(errors);
    }
}

