/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.ml.regression.loss.dataset.ARegressionMeasure;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class R2
extends ARegressionMeasure {
    @Override
    public double score(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        this.checkConsistency(expected, predicted);
        double meanExpected = expected.stream().mapToDouble(x -> x).average().getAsDouble();
        double sumOfActualSquares = 0.0;
        double sumOfExpectedSquares = 0.0;
        for (int i = 0; i < predicted.size(); ++i) {
            sumOfActualSquares += Math.pow(predicted.get(i).getPrediction() - meanExpected, 2.0);
            sumOfExpectedSquares += Math.pow(expected.get(i) - meanExpected, 2.0);
        }
        if (sumOfExpectedSquares == 0.0) {
            throw new IllegalStateException("Sum of expected squares must not be null.");
        }
        return sumOfActualSquares / sumOfExpectedSquares;
    }
}

