/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.ml.regression.loss.dataset.AUnboundedRegressionMeasure;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class WeightedAbsoluteError
extends AUnboundedRegressionMeasure {
    private double weightUnderestimation = 1.0;

    public WeightedAbsoluteError() {
    }

    public WeightedAbsoluteError(double weightUnderestimation) {
        this.weightUnderestimation = weightUnderestimation;
    }

    @Override
    public double loss(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        ArrayList<Double> errors = new ArrayList<Double>();
        for (int i = 0; i < expected.size(); ++i) {
            double difference = predicted.get(i).getPrediction() - expected.get(i);
            Double error = difference <= 0.0 ? Double.valueOf(-this.weightUnderestimation * difference) : Double.valueOf(this.weightUnderestimation * difference);
            errors.add(error);
        }
        return StatisticsUtil.mean(errors);
    }
}

