/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.dataset;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.ml.regression.loss.dataset.AUnboundedRegressionMeasure;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.ai.ml.regression.evaluation.IRegressionPrediction;

public class WeightedAsymmetricAbsoluteError
extends AUnboundedRegressionMeasure {
    private double weightUnderestimation = 1.0;
    private double weightOverestimation = 1.0;

    public WeightedAsymmetricAbsoluteError() {
    }

    public WeightedAsymmetricAbsoluteError(double weightUnderestimation, double weightOverestimation) {
        this.weightUnderestimation = weightUnderestimation;
        this.weightOverestimation = weightOverestimation;
    }

    @Override
    public double loss(List<? extends Double> expected, List<? extends IRegressionPrediction> predicted) {
        ArrayList<Double> errors = new ArrayList<Double>();
        for (int i = 0; i < expected.size(); ++i) {
            double d = predicted.get(i).getPrediction() - expected.get(i);
            Double error = d <= 0.0 ? Double.valueOf(-this.weightUnderestimation * d) : Double.valueOf(this.weightOverestimation * d);
            errors.add(error);
        }
        return StatisticsUtil.mean(errors);
    }
}

