/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.regression.loss.instance;

import ai.libs.jaicore.ml.classification.loss.instance.AInstanceMeasure;

public class SquaredLogarithmicError
extends AInstanceMeasure<Double, Double> {
    private static final double DEF_EPSILON = 1.0E-15;
    private final double epsilon;

    public SquaredLogarithmicError(double epsilon) {
        this.epsilon = epsilon;
    }

    public SquaredLogarithmicError() {
        this(1.0E-15);
    }

    @Override
    public double loss(Double expected, Double predicted) {
        return Math.pow(Math.log(this.clip(expected)) - Math.log(this.clip(predicted)), 2.0);
    }

    private double clip(double value) {
        if (value == 0.0) {
            return this.epsilon;
        }
        return value;
    }
}

