/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.scikitwrapper;

import ai.libs.jaicore.ml.scikitwrapper.IProcessListener;
import ai.libs.jaicore.processes.EOperatingSystem;
import ai.libs.jaicore.processes.ProcessUtil;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AProcessListener
implements IProcessListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AProcessListener.class);
    private boolean listenForPIDFromProcess = false;
    private int processIDObtainedFromListening = -1;

    public AProcessListener() {
    }

    public AProcessListener(boolean listenForPIDFromProcess) {
        this.listenForPIDFromProcess = listenForPIDFromProcess;
    }

    @Override
    public void listenTo(Process process) throws IOException, InterruptedException {
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
             BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            while (process.isAlive()) {
                String line;
                if (Thread.interrupted()) {
                    if (this.listenForPIDFromProcess && this.processIDObtainedFromListening > 0) {
                        ProcessUtil.killProcess((int)this.processIDObtainedFromListening);
                    } else {
                        ProcessUtil.killProcess((Process)process);
                    }
                    throw new InterruptedException("Process execution was interrupted.");
                }
                while (this.checkReady(inputReader) && (line = inputReader.readLine()) != null) {
                    this.handleProcessIDLine(line);
                    if (line.contains("import imp") || line.contains("imp module")) continue;
                    this.handleInput(line);
                }
                while (this.checkReady(inputReader) && (line = errorReader.readLine()) != null) {
                    if (line.contains("import imp") || line.contains("imp module")) continue;
                    this.handleError(line);
                }
            }
        }
    }

    private boolean checkReady(BufferedReader inputReader) throws IOException {
        if (ProcessUtil.getOS() == EOperatingSystem.MAC) {
            return inputReader.ready();
        }
        return true;
    }

    private void handleProcessIDLine(String line) {
        if (this.listenForPIDFromProcess && !Strings.isNullOrEmpty((String)line)) {
            if (line.startsWith("CURRENT_PID:")) {
                this.processIDObtainedFromListening = Integer.parseInt(line.replace("CURRENT_PID:", "").trim());
                LOGGER.debug("Listen to process id: {}", (Object)this.processIDObtainedFromListening);
            }
            LOGGER.trace("Other console output: {}", (Object)line);
        }
    }

    public abstract void handleError(String var1) throws IOException, InterruptedException;

    public abstract void handleInput(String var1) throws IOException, InterruptedException;
}

