package ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.lc;

/**
 * This class contains required constant names for the linear combination
 * learning curve.
 * 
 * @author Felix Weiland
 *
 */
public class LinearCombinationConstants {

	private LinearCombinationConstants() {

	}

	// Function names
	public static final String VAPOR_PRESSURE = "vapor_pressure";
	public static final String POW_3 = "pow_3";
	public static final String LOG_LOG_LINEAR = "log_log_linear";
	public static final String HILL_3 = "hill_3";
	public static final String LOG_POWER = "log_power";
	public static final String POW_4 = "pow_4";
	public static final String MMF = "mmf";
	public static final String EXP_4 = "exp_4";
	public static final String JANOSCHEK = "janoschek";
	public static final String WEIBULL = "weibull";
	public static final String ILOG_2 = "ilog_2";

	// Parameter names
	public static final String A = "a";
	public static final String B = "b";
	public static final String C = "c";
	public static final String E = "e";
	public static final String Y = "y";
	public static final String ALPHA = "alpha";
	public static final String BETA = "beta";
	public static final String DELTA = "delta";
	public static final String ETA = "eta";
	public static final String KAPPA = "kappa";
}
