/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.theories.EvaluablePredicate;
import ai.libs.jaicore.logic.fol.util.ForwardChainer;
import ai.libs.jaicore.logic.fol.util.ForwardChainingProblem;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCAction;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.OCIPMethod;
import ai.libs.jaicore.planning.hierarchical.problems.ceocstn.OCMethod;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import ai.libs.jaicore.planning.hierarchical.problems.stn.STNPlanningDomain;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPlannerUtil {
    private static final Logger logger = LoggerFactory.getLogger(TaskPlannerUtil.class);
    private Map<String, EvaluablePredicate> evaluablePlanningPredicates;

    public TaskPlannerUtil(Map<String, EvaluablePredicate> evaluablePlanningPredicates) {
        this.evaluablePlanningPredicates = evaluablePlanningPredicates;
    }

    public Collection<MethodInstance> getMethodInstancesForTaskThatAreApplicableInState(CNFFormula knowledge, Collection<? extends Method> methods, Literal task, Monom state, List<Literal> remainingProblems) throws InterruptedException {
        ArrayList<MethodInstance> applicableDerivedMethods = new ArrayList<MethodInstance>();
        for (Method method : methods) {
            if (!method.getTask().getPropertyName().equals(task.getPropertyName())) continue;
            Collection<MethodInstance> additionalInstances = this.getMethodInstancesForTaskThatAreApplicableInState(knowledge, method, task, state, remainingProblems);
            assert (!method.isLonely() || additionalInstances.size() <= 1) : "Computed more than one instantiations for lonely method: \n\t" + additionalInstances.stream().map(n -> n.toString()).collect(Collectors.joining("\n\t"));
            applicableDerivedMethods.addAll(additionalInstances);
        }
        return applicableDerivedMethods;
    }

    public Collection<MethodInstance> getMethodInstancesForTaskThatAreApplicableInState(CNFFormula knowledge, Method method, Literal task, Monom state, List<Literal> remainingProblems) throws InterruptedException {
        ArrayList<MethodInstance> applicableDerivedMethodInstances = new ArrayList<MethodInstance>();
        Collection<Map<VariableParam, LiteralParam>> maps = this.getMappingsThatMatchTasksAndMakesItApplicable(knowledge, method.getTask(), task, method.getPrecondition(), state);
        for (Map<VariableParam, LiteralParam> grounding : maps) {
            HashMap<VariableParam, ConstantParam> basicConstantGrounding = new HashMap<VariableParam, ConstantParam>();
            for (VariableParam key : grounding.keySet()) {
                basicConstantGrounding.put(key, (ConstantParam)grounding.get(key));
            }
            ArrayList<HashMap<VariableParam, ConstantParam>> extendedGroundings = new ArrayList<HashMap<VariableParam, ConstantParam>>();
            if (method instanceof OCIPMethod) {
                OCIPMethod castedMethod = (OCIPMethod)method;
                Collection collection = SetUtil.difference((Collection)castedMethod.getEvaluablePrecondition().getVariableParams(), basicConstantGrounding.keySet());
                HashMap<Literal, EvaluablePredicate> evaluablePredicatesForLiterals = new HashMap<Literal, EvaluablePredicate>();
                for (Literal l : castedMethod.getEvaluablePrecondition()) {
                    if (this.evaluablePlanningPredicates == null || !this.evaluablePlanningPredicates.containsKey(l.getPropertyName())) {
                        throw new IllegalArgumentException("The literal " + l + " is used in an evaluated precondition, but no evaluator has been specified for it.");
                    }
                    evaluablePredicatesForLiterals.put(l, this.evaluablePlanningPredicates.get(l.getPropertyName()));
                }
                if (!collection.isEmpty()) {
                    LinkedList<Literal> literalsOrderedByOracability = new LinkedList<Literal>(castedMethod.getEvaluablePrecondition().stream().sorted((l1, l2) -> {
                        EvaluablePredicate el1 = (EvaluablePredicate)evaluablePredicatesForLiterals.get(l1);
                        EvaluablePredicate el2 = (EvaluablePredicate)evaluablePredicatesForLiterals.get(l2);
                        if (el1.isOracable() != el2.isOracable()) {
                            return el1.isOracable() ? -1 : 1;
                        }
                        if (!el1.isOracable()) {
                            return 0;
                        }
                        int ungroundParamsInL1 = SetUtil.intersection((Collection)ungroundParamsInEvaluablePrecondition, (Collection)l1.getParameters()).size();
                        int ungroundParamsInL2 = SetUtil.intersection((Collection)ungroundParamsInEvaluablePrecondition, (Collection)l2.getParameters()).size();
                        return ungroundParamsInL1 - ungroundParamsInL2;
                    }).collect(Collectors.toList()));
                    if (!((EvaluablePredicate)evaluablePredicatesForLiterals.get(literalsOrderedByOracability.peek())).isOracable()) {
                        throw new IllegalArgumentException("None of the literals " + literalsOrderedByOracability + " is oracable");
                    }
                    ArrayList oracleGroundings = new ArrayList();
                    oracleGroundings.add(basicConstantGrounding);
                    this.getOracleGroundings(collection, literalsOrderedByOracability, state, new HashSet<VariableParam>(), oracleGroundings, basicConstantGrounding);
                    extendedGroundings.addAll(oracleGroundings);
                } else {
                    boolean allSatisfied = true;
                    for (Literal l : castedMethod.getEvaluablePrecondition()) {
                        ConstantParam[] params = new ConstantParam[l.getParameters().size()];
                        for (int i = 0; i < params.length; ++i) {
                            LiteralParam param = (LiteralParam)l.getParameters().get(i);
                            params[i] = param instanceof ConstantParam ? (ConstantParam)param : (ConstantParam)basicConstantGrounding.get(param);
                        }
                        if (((EvaluablePredicate)evaluablePredicatesForLiterals.get(l)).test(state, params) == l.isPositive()) continue;
                        allSatisfied = false;
                        break;
                    }
                    if (allSatisfied) {
                        extendedGroundings.add(basicConstantGrounding);
                    }
                }
            } else {
                extendedGroundings.add(basicConstantGrounding);
            }
            for (Map map : extendedGroundings) {
                HashSet knownConstants = new HashSet(state.getConstantParams());
                for (Literal l : remainingProblems) {
                    knownConstants.addAll(l.getConstantParams());
                }
                List unboundParams = SetUtil.difference(method.getParameters(), map.keySet());
                if (method instanceof OCMethod) {
                    Collection unboundOutputParams = SetUtil.intersection((Collection)unboundParams, ((OCMethod)method).getOutputs());
                    assert (unboundOutputParams.equals(unboundParams)) : "Some of the inputs of method " + method.getName() + " have not been ground. Unground inputs: " + SetUtil.difference((Collection)unboundParams, (Collection)unboundOutputParams);
                    int indexForNewVariable = 1;
                    for (VariableParam v : unboundOutputParams) {
                        ConstantParam p;
                        while (knownConstants.contains(p = new ConstantParam("newVar" + indexForNewVariable++))) {
                        }
                        map.put(v, p);
                        unboundParams.remove(v);
                    }
                    assert (unboundParams.isEmpty()) : "Method " + method.getName() + " must be ground completely before processing. Here, " + unboundParams + " are unground.";
                } else if (!unboundParams.isEmpty()) {
                    throw new IllegalStateException("Could not compute a complete grounding for method " + method.getName() + ". The following parameters were not ground until the end: " + unboundParams);
                }
                applicableDerivedMethodInstances.add(new MethodInstance(method, map));
                if (!method.isLonely()) continue;
                return applicableDerivedMethodInstances;
            }
        }
        return applicableDerivedMethodInstances;
    }

    private void getOracleGroundings(Collection<VariableParam> ungroundParamsInEvaluablePrecondition, Queue<Literal> literalsOrderedByOracability, Monom state, Set<VariableParam> paramsGroundSoFar, Collection<Map<VariableParam, ConstantParam>> groundingsFixedSoFar, Map<VariableParam, ConstantParam> basicConstantGrounding) {
        if (literalsOrderedByOracability.isEmpty()) {
            return;
        }
        Literal l = literalsOrderedByOracability.poll();
        Collection paramsThatNeedGrounding = SetUtil.intersection((Collection)SetUtil.difference(ungroundParamsInEvaluablePrecondition, paramsGroundSoFar), (Collection)l.getParameters());
        logger.info("Now checking validity of {}. Set of params that still need grounding: {}", (Object)l, (Object)paramsThatNeedGrounding);
        if (paramsThatNeedGrounding.size() > 1) {
            throw new UnsupportedOperationException("Currently only support for at most one unground variable! Here, the following variables of \"" + l + "\"need grounding: " + paramsThatNeedGrounding);
        }
        ArrayList<Map<VariableParam, ConstantParam>> localCopyOfCurrentGrounding = new ArrayList<Map<VariableParam, ConstantParam>>(groundingsFixedSoFar);
        VariableParam paramToBeGround = null;
        Object[] params = new ConstantParam[l.getParameters().size()];
        int indexOfParam = -1;
        HashMap<VariableParam, Integer> positionsOfVariableParams = new HashMap<VariableParam, Integer>();
        for (int i = 0; i < params.length; ++i) {
            boolean parameterHasBeenDecidedByOracle;
            LiteralParam literalParam = (LiteralParam)l.getParameters().get(i);
            boolean parameterIsConstant = literalParam instanceof ConstantParam;
            boolean parameterIsGround = basicConstantGrounding.containsKey(literalParam);
            boolean bl = parameterHasBeenDecidedByOracle = !parameterIsConstant && !parameterIsGround && paramsGroundSoFar.contains(literalParam);
            if (parameterIsConstant) {
                params[i] = (ConstantParam)literalParam;
                continue;
            }
            if (parameterIsGround) {
                params[i] = basicConstantGrounding.get(literalParam);
                continue;
            }
            positionsOfVariableParams.put((VariableParam)literalParam, i);
            if (parameterHasBeenDecidedByOracle) continue;
            indexOfParam = i;
            paramToBeGround = (VariableParam)l.getParameters().get(i);
        }
        groundingsFixedSoFar.clear();
        for (Map map : localCopyOfCurrentGrounding) {
            logger.info("Considering combination of previously fixed oracle decisions: {}", (Object)map);
            for (VariableParam oracledParam : paramsGroundSoFar) {
                if (!positionsOfVariableParams.containsKey(oracledParam)) {
                    logger.debug("Ignoring ground value {} of param {}, because this param does not occur in the literal", map.get(oracledParam), (Object)oracledParam);
                    continue;
                }
                logger.debug("Inserting {} at position {} in the param array.", map.get(oracledParam), positionsOfVariableParams.get(oracledParam));
                params[((Integer)positionsOfVariableParams.get((Object)oracledParam)).intValue()] = (ConstantParam)map.get(oracledParam);
            }
            logger.info("Params for literal are {}", (Object)Arrays.toString(params));
            int finalizedIndexOfParam = indexOfParam;
            if (finalizedIndexOfParam >= 0 != (paramToBeGround != null)) {
                throw new IllegalStateException("Param to be ground is " + paramToBeGround + ", but the index in the literal is " + finalizedIndexOfParam);
            }
            EvaluablePredicate predicate = this.evaluablePlanningPredicates.get(l.getPropertyName());
            if (paramToBeGround != null) {
                Collection possibleGroundingsOfThisPredicate;
                logger.info("No valid grounding for param {} are known, so apply oracle.", (Object)paramToBeGround);
                Collection collection = possibleGroundingsOfThisPredicate = l.isPositive() ? predicate.getParamsForPositiveEvaluation(state, (ConstantParam[])params) : predicate.getParamsForNegativeEvaluation(state, (ConstantParam[])params);
                if (possibleGroundingsOfThisPredicate == null) {
                    logger.warn("Predicate {} returned NULL for params {} in state {}. Canceling grounding process.", new Object[]{l.getPropertyName(), params, state});
                    return;
                }
                Collection possibleValuesForNewParamInThisGrounding = possibleGroundingsOfThisPredicate.stream().map(s -> (ConstantParam)s.get(finalizedIndexOfParam)).collect(Collectors.toSet());
                for (ConstantParam oracledParamOfThisLiteral : possibleValuesForNewParamInThisGrounding) {
                    HashMap<VariableParam, ConstantParam> extendedOracleGrounding = new HashMap<VariableParam, ConstantParam>(map);
                    extendedOracleGrounding.put(paramToBeGround, oracledParamOfThisLiteral);
                    groundingsFixedSoFar.add(extendedOracleGrounding);
                }
                logger.info("Candidates for grounding is now {}", groundingsFixedSoFar);
                paramsGroundSoFar.add(paramToBeGround);
                continue;
            }
            logger.info("No new parameters to ground. Only testing {} (evaluated by {}) against params {} given groundings {}.", new Object[]{l, predicate.getClass().getName(), Arrays.toString(params), groundingsFixedSoFar});
            localCopyOfCurrentGrounding.stream().filter(arg_0 -> TaskPlannerUtil.lambda$getOracleGroundings$3(predicate, state, (ConstantParam[])params, l, arg_0)).forEach(g -> groundingsFixedSoFar.add((Map<VariableParam, ConstantParam>)g));
        }
        logger.info("Proceeding with extended oracle grounding: {}", groundingsFixedSoFar);
        this.getOracleGroundings(ungroundParamsInEvaluablePrecondition, literalsOrderedByOracability, state, paramsGroundSoFar, groundingsFixedSoFar, basicConstantGrounding);
    }

    public Collection<Action> getActionsForPrimitiveTaskThatAreApplicableInState(CNFFormula knowledge, Operation op, Literal task, Monom state) throws InterruptedException {
        ArrayList<Action> applicableDerivedActions = new ArrayList<Action>();
        ArrayList<VariableParam> allParams = new ArrayList<VariableParam>();
        allParams.addAll(op.getParams());
        String taskNameOfOperation = op.getName() + "(";
        for (int i = 0; i < allParams.size(); ++i) {
            if (i > 0) {
                taskNameOfOperation = taskNameOfOperation + ", ";
            }
            taskNameOfOperation = taskNameOfOperation + ((VariableParam)allParams.get(i)).getName();
        }
        taskNameOfOperation = taskNameOfOperation + ")";
        Literal taskOfOperation = new Literal(taskNameOfOperation);
        for (Map<VariableParam, LiteralParam> grounding : this.getMappingsThatMatchTasksAndMakesItApplicable(knowledge, taskOfOperation, task, op.getPrecondition(), state)) {
            HashMap<VariableParam, ConstantParam> constantGrounding = new HashMap<VariableParam, ConstantParam>();
            for (VariableParam key : grounding.keySet()) {
                constantGrounding.put(key, (ConstantParam)grounding.get(key));
            }
            if (op instanceof CEOCOperation) {
                applicableDerivedActions.add(new CEOCAction((CEOCOperation)op, constantGrounding));
                continue;
            }
            applicableDerivedActions.add(new Action(op, constantGrounding));
        }
        return applicableDerivedActions;
    }

    private Collection<Map<VariableParam, LiteralParam>> getMappingsThatMatchTasksAndMakesItApplicable(CNFFormula knowledge, Literal methodOrPrimitiveTask, Literal target, Monom preconditionOfMethodOrPrimitive, Monom state) throws InterruptedException {
        assert (preconditionOfMethodOrPrimitive != null) : "precondition of methode or primitive task " + methodOrPrimitiveTask + " is null";
        logger.info("Now computing the possible applications of method {} for task {}", (Object)methodOrPrimitiveTask, (Object)target);
        if (preconditionOfMethodOrPrimitive.isEmpty()) {
            int numParams = target.getParameters().size();
            HashMap<VariableParam, LiteralParam> grounding = new HashMap<VariableParam, LiteralParam>();
            for (int i = 0; i < numParams; ++i) {
                VariableParam paramOfPreconditionLiteral = (VariableParam)methodOrPrimitiveTask.getParameters().get(i);
                LiteralParam targetParam = (LiteralParam)target.getParameters().get(i);
                grounding.put(paramOfPreconditionLiteral, targetParam);
            }
            ArrayList<Map<VariableParam, LiteralParam>> groundings = new ArrayList<Map<VariableParam, LiteralParam>>();
            groundings.add(grounding);
            return groundings;
        }
        if (!methodOrPrimitiveTask.getPropertyName().equals(target.getPropertyName())) {
            throw new IllegalArgumentException("The method used to refine task \"" + target + "\" must be compatible with it, i.e. designed for that task, but it is designed for \"" + methodOrPrimitiveTask.getPropertyName() + "\"");
        }
        List taskParams = target.getParameters();
        List methodTaskParams = methodOrPrimitiveTask.getVariableParams();
        if (taskParams.size() != methodTaskParams.size() || methodTaskParams.size() != methodOrPrimitiveTask.getParameters().size()) {
            throw new IllegalArgumentException("A method or operation associated with task \"" + methodOrPrimitiveTask + "\" is used to refine task \"" + target + "\". There is a parameter count clash!");
        }
        HashMap taskParameterMapping = new HashMap();
        for (int i = 0; i < taskParams.size(); ++i) {
            taskParameterMapping.put(methodTaskParams.get(i), taskParams.get(i));
        }
        ArrayList<Map<VariableParam, LiteralParam>> groundings = new ArrayList<Map<VariableParam, LiteralParam>>();
        assert (knowledge == null || !knowledge.hasDisjunctions()) : "Currently no support for non-factbase knowledge!";
        Monom unitedKnowledge = new Monom((Collection)state);
        if (knowledge != null) {
            unitedKnowledge.addAll((Collection)knowledge.extractMonom());
        }
        List outputs = SetUtil.difference((List)target.getVariableParams(), (Collection)preconditionOfMethodOrPrimitive.getVariableParams());
        List parametersThatNeedGrounding = SetUtil.difference((List)target.getVariableParams(), (Collection)outputs);
        Collection groundingsOfTargetTask = SetUtil.allTotalMappings((Collection)parametersThatNeedGrounding, (Collection)unitedKnowledge.getConstantParams());
        if (groundingsOfTargetTask.isEmpty()) {
            groundingsOfTargetTask.add(new HashMap());
        }
        for (Map targetTaskGrounding : groundingsOfTargetTask) {
            Collection restMaps;
            HashMap<VariableParam, Object> groundingForMethodOrPrimitiveTask = new HashMap<VariableParam, Object>();
            for (VariableParam var : methodTaskParams) {
                LiteralParam correspondingVarInTaskLiteral = (LiteralParam)taskParameterMapping.get(var);
                if (correspondingVarInTaskLiteral instanceof ConstantParam) {
                    groundingForMethodOrPrimitiveTask.put(var, (ConstantParam)correspondingVarInTaskLiteral);
                    continue;
                }
                if (!targetTaskGrounding.containsKey(correspondingVarInTaskLiteral)) continue;
                groundingForMethodOrPrimitiveTask.put(var, targetTaskGrounding.get(correspondingVarInTaskLiteral));
            }
            Monom positiveRequirements = new Monom((Collection)preconditionOfMethodOrPrimitive.stream().filter(l -> l.isPositive()).collect(Collectors.toList()), groundingForMethodOrPrimitiveTask);
            if (!positiveRequirements.isEmpty()) {
                ForwardChainer fc = new ForwardChainer(new ForwardChainingProblem(unitedKnowledge, positiveRequirements, true));
                try {
                    restMaps = fc.call();
                }
                catch (AlgorithmExecutionCanceledException | TimeoutException throwable) {
                    logger.warn("The forward chainer was canceled or timed out, so maybe not all bindings could be computed!");
                    return groundings;
                }
            } else {
                restMaps = new ArrayList();
            }
            if (restMaps.isEmpty()) {
                restMaps.add(new HashMap());
            }
            for (Map map : restMaps) {
                HashMap<VariableParam, Object> completeGroundingMethod = new HashMap<VariableParam, Object>();
                completeGroundingMethod.putAll(groundingForMethodOrPrimitiveTask);
                completeGroundingMethod.putAll(map);
                logger.debug("Now considering grounding {}", completeGroundingMethod);
                Monom precondition = new Monom((Collection)preconditionOfMethodOrPrimitive, completeGroundingMethod);
                if (precondition.isContradictory()) {
                    logger.debug("Ignoring this grounding because it makes the precondition contradictory.");
                    continue;
                }
                List positiveLiterals = precondition.stream().filter(l -> l.isPositive()).collect(Collectors.toList());
                List negativeLiterals = precondition.stream().filter(l -> l.isNegated()).map(l -> l.clone().toggleNegation()).collect(Collectors.toList());
                if (unitedKnowledge.containsAll(positiveLiterals) && SetUtil.intersection((Collection)unitedKnowledge, negativeLiterals).isEmpty()) {
                    logger.debug("Adding the grounding.");
                    groundings.add(completeGroundingMethod);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                for (Literal l2 : positiveLiterals) {
                    if (unitedKnowledge.contains((Object)l2)) continue;
                    logger.debug("Ignoring this grounding because the united knowledge {} does not contain the positive literal {}", (Object)unitedKnowledge, (Object)l2);
                    if (!logger.isTraceEnabled()) break;
                    for (Literal l22 : unitedKnowledge) {
                        logger.trace("Comparing {} of signature {}{} with {} of signature{}{}: {}/{}", new Object[]{l2, l2.getClass().getName(), l2.getParameters().stream().map(p -> p.getName() + ":" + p.getType()).collect(Collectors.toList()), l22, l22.getClass().getName(), l22.getParameters().stream().map(p -> p.getName() + ":" + p.getType()).collect(Collectors.toList()), l2.equals((Object)l22), l22.equals((Object)l2)});
                    }
                }
                if (SetUtil.intersection((Collection)unitedKnowledge, negativeLiterals).isEmpty()) continue;
                logger.debug("Ignoring this grounding because of an non-empty intersection of the united knowledge {} and the negative literals {}", (Object)unitedKnowledge, negativeLiterals);
            }
        }
        logger.info("Admissible groundings for {} with precondition {} on {} in state {} are: {}", new Object[]{methodOrPrimitiveTask, preconditionOfMethodOrPrimitive, target, state, groundings});
        return groundings;
    }

    public List<Literal> getTaskChainOfTotallyOrderedNetwork(TaskNetwork network) {
        ArrayList<Literal> taskSequence = new ArrayList<Literal>();
        if (network.getSources().isEmpty()) {
            return taskSequence;
        }
        Literal current = (Literal)network.getSources().iterator().next();
        while (current != null) {
            taskSequence.add(current);
            Set successors = network.getSuccessors(current);
            current = successors.isEmpty() ? null : (Literal)successors.iterator().next();
        }
        return taskSequence;
    }

    public Map<String, EvaluablePredicate> getEvaluablePlanningPredicates() {
        return this.evaluablePlanningPredicates;
    }

    public void setEvaluablePlanningPredicates(Map<String, EvaluablePredicate> evaluablePlanningPredicates) {
        this.evaluablePlanningPredicates = evaluablePlanningPredicates;
    }

    public Optional<? extends Operation> getOperationWithName(STNPlanningDomain domain, String nameOfOperation) {
        Objects.requireNonNull(domain);
        Objects.requireNonNull(nameOfOperation);
        return domain.getOperations().stream().filter(o -> o.getName().equals(nameOfOperation)).findAny();
    }

    public List<CEOCAction> recoverPlanFromActionEncoding(STNPlanningDomain domain, List<String> actionEncodings) {
        ArrayList<CEOCAction> plan = new ArrayList<CEOCAction>();
        Pattern p = Pattern.compile("([^(]+)\\(([^,]*|([^,]*(?:,[^,]*)+))\\)");
        for (String actionEncoding : actionEncodings) {
            Matcher m = p.matcher(actionEncoding);
            if (!m.find()) {
                throw new IllegalArgumentException("Cannot match the action encoding " + actionEncoding);
            }
            Optional<? extends Operation> op = this.getOperationWithName(domain, m.group(1));
            if (!op.isPresent()) {
                throw new IllegalArgumentException("Invalid action " + actionEncoding + ", because no operation with name \"" + m.group(1) + "\" is known in the given domain.");
            }
            List args = Arrays.asList(m.group(2).split(",")).stream().map(param -> new ConstantParam(param.trim())).collect(Collectors.toList());
            HashMap<VariableParam, ConstantParam> grounding = new HashMap<VariableParam, ConstantParam>();
            List<VariableParam> params = op.get().getParams();
            for (int i = 0; i < params.size(); ++i) {
                grounding.put(params.get(i), (ConstantParam)args.get(i));
            }
            plan.add(new CEOCAction((CEOCOperation)op.get(), grounding));
        }
        return plan;
    }

    private static /* synthetic */ boolean lambda$getOracleGroundings$3(EvaluablePredicate predicate, Monom state, ConstantParam[] params, Literal l, Map grounding) {
        return predicate.test(state, params) == l.isPositive();
    }
}

