/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.ceocstn.converters;

import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.hierarchical.problems.ceocstn.CEOCSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;

public class CEOCSTN2Shop2 {
    private static String packageName;

    public static void printDomain(CEOCSTNPlanningProblem problem, File output) throws IOException {
        FileWriter fileWriter = new FileWriter(output);
        try (BufferedWriter bw = new BufferedWriter(fileWriter);){
            String fileName = output.getName();
            fileName = fileName.substring(0, fileName.indexOf(".")).toLowerCase();
            if (packageName != "") {
                bw.write("(int-package : " + packageName + ")");
                bw.flush();
            }
            bw.write("(defun define-" + fileName + "-domain()\n");
            bw.write(CEOCSTN2Shop2.indent(1) + "(let (( * define-silently* t))\n");
            bw.flush();
            bw.write(CEOCSTN2Shop2.indent(1) + "(defdomain (" + fileName + " :redinfe-ok t)(\n");
            bw.flush();
            bw.write(CEOCSTN2Shop2.indent(1) + ")\n");
            bw.write("\t)\n)");
            bw.flush();
        }
    }

    public static void printOperation(BufferedWriter bw, CEOCOperation operation, int i) throws IOException {
        bw.write(CEOCSTN2Shop2.indent(i) + "(:operator (!" + operation.getName());
        operation.getParams().stream().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n ");
        CEOCSTN2Shop2.printMonom(bw, operation.getPrecondition(), 4);
        CEOCSTN2Shop2.printMonomMap(bw, operation.getDeleteLists(), 4);
        CEOCSTN2Shop2.printMonomMap(bw, operation.getAddLists(), 4);
        bw.write(CEOCSTN2Shop2.indent(i) + ")\n\n");
        bw.flush();
    }

    private static void printMonomMap(BufferedWriter bw, Map<CNFFormula, Monom> map, int i) throws IOException {
        map.values().stream().forEach(member -> {
            try {
                CEOCSTN2Shop2.printMonom(bw, member, 4);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.flush();
    }

    public static void printMonom(BufferedWriter bw, Monom monom, int i) throws IOException {
        CEOCSTN2Shop2.printMonom(bw, monom, i, false);
    }

    public static void printMonom(BufferedWriter bw, Monom monom, int i, boolean newline) throws IOException {
        bw.write(CEOCSTN2Shop2.indent(i) + "(");
        monom.stream().forEach(lit -> {
            try {
                CEOCSTN2Shop2.printLiteral(bw, lit);
                if (newline) {
                    bw.write("\n" + CEOCSTN2Shop2.indent(i) + " ");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n");
        bw.flush();
    }

    public static void printLiteral(BufferedWriter bw, Literal lit) throws IOException {
        bw.write(" (");
        bw.write(lit.getProperty());
        lit.getParameters().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")");
        bw.flush();
    }

    public static void printMethod(BufferedWriter bw, Method method, int i) throws IOException {
        bw.write(CEOCSTN2Shop2.indent(i) + "(:method (" + method.getName());
        method.getParameters().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n");
        CEOCSTN2Shop2.printMonom(bw, method.getPrecondition(), i + 1);
        CEOCSTN2Shop2.printNetwork(bw, (Literal)method.getNetwork().getRoot(), method.getNetwork(), true, 4);
        bw.write(CEOCSTN2Shop2.indent(i) + ")\n");
        bw.flush();
    }

    private static void printNetwork(BufferedWriter bw, Literal lit, TaskNetwork network, boolean ordered, int i) throws IOException {
        bw.write(CEOCSTN2Shop2.indent(i) + "(");
        if (lit.equals(network.getRoot())) {
            if (ordered) {
                bw.write(":ordered\n");
            } else {
                bw.write(":unordered\n");
            }
        }
        bw.write(CEOCSTN2Shop2.indent(i + 1) + "(" + lit.getProperty());
        bw.flush();
        lit.getParameters().stream().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n");
        network.getSuccessors(lit).stream().forEach(literal -> {
            try {
                CEOCSTN2Shop2.printNetwork(bw, literal, network, i + 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(CEOCSTN2Shop2.indent(i) + ")\n");
        bw.flush();
    }

    private static void printNetwork(BufferedWriter bw, Literal lit, TaskNetwork network, int i) throws IOException {
        bw.write(CEOCSTN2Shop2.indent(i) + "(" + lit.getProperty());
        lit.getParameters().stream().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n");
    }

    public static void printProblem(CEOCSTNPlanningProblem problem, File output) throws IOException {
        FileWriter fileWriter = new FileWriter(output);
        BufferedWriter bw = new BufferedWriter(fileWriter);
        String fileName = output.getName();
        fileName = fileName.substring(0, fileName.indexOf(".")).toLowerCase();
        if (packageName != "") {
            bw.write("(int-package : " + packageName + ")");
            bw.flush();
        }
        bw.write("(make-problem '" + fileName + "'-01 ' " + fileName + "\n");
        bw.write(CEOCSTN2Shop2.indent(1) + "(\n");
        CEOCSTN2Shop2.printMonom(bw, problem.getInit(), 2, true);
        CEOCSTN2Shop2.printNetwork(bw, (Literal)problem.getNetwork().getRoot(), problem.getNetwork(), 2);
        bw.write(CEOCSTN2Shop2.indent(1) + ")\n");
        bw.write(")");
        bw.flush();
    }

    public static String indent(int numberOfIntends) {
        String r = "";
        for (int i = 0; i < numberOfIntends; ++i) {
            r = r + "\t";
        }
        return r;
    }

    public static void print(CEOCSTNPlanningProblem problem) {
        CEOCSTN2Shop2.print(problem, "");
    }

    public static void print(CEOCSTNPlanningProblem problem, String packageName) {
        CEOCSTN2Shop2.packageName = packageName;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Domain-File");
        chooser.showOpenDialog(null);
        File domainFile = chooser.getSelectedFile();
        try {
            CEOCSTN2Shop2.printDomain(problem, domainFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        chooser.setDialogTitle("Problem-File");
        chooser.showOpenDialog(null);
        File problemFile = chooser.getSelectedFile();
        try {
            CEOCSTN2Shop2.printProblem(problem, problemFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

