/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.algorithms.strips.forward;

import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsForwardPlanningNode;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.classical.problems.strips.StripsAction;
import ai.libs.jaicore.planning.classical.problems.strips.StripsPlanningProblem;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.model.travesaltree.NodeExpansionDescription;
import ai.libs.jaicore.search.model.travesaltree.NodeType;
import ai.libs.jaicore.search.structure.graphgenerator.NodeGoalTester;
import ai.libs.jaicore.search.structure.graphgenerator.SingleRootGenerator;
import ai.libs.jaicore.search.structure.graphgenerator.SingleSuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripsForwardPlanningGraphGenerator
implements GraphGenerator<StripsForwardPlanningNode, String> {
    private final StripsPlanningProblem problem;
    private static final Logger logger = LoggerFactory.getLogger(StripsForwardPlanningGraphGenerator.class);
    private final Monom initState;
    private final Map<StripsForwardPlanningNode, List<StripsAction>> returnedActions = new HashMap<StripsForwardPlanningNode, List<StripsAction>>();
    private final Map<StripsForwardPlanningNode, List<StripsAction>> unreturnedActions = new HashMap<StripsForwardPlanningNode, List<StripsAction>>();
    private final Set<StripsForwardPlanningNode> completelyExpandedNodes = new HashSet<StripsForwardPlanningNode>();

    public StripsForwardPlanningGraphGenerator(StripsPlanningProblem problem) {
        this.problem = problem;
        this.initState = problem.getInitState();
    }

    public SingleRootGenerator<StripsForwardPlanningNode> getRootGenerator() {
        return () -> {
            StripsForwardPlanningNode root = new StripsForwardPlanningNode(new Monom(), new Monom(), null);
            return root;
        };
    }

    private List<StripsAction> getApplicableActionsInNode(StripsForwardPlanningNode node) {
        logger.info("Computing successors for node {}", (Object)node);
        long start = System.currentTimeMillis();
        Monom state = node.getStateRelativeToInitState(this.initState);
        List<StripsAction> applicableActions = StripsUtil.getApplicableActionsInState(state, this.problem.getDomain());
        logger.debug("Computation of applicable actions took {}ms", (Object)(System.currentTimeMillis() - start));
        return applicableActions;
    }

    private StripsAction getRandomApplicableActionInNode(StripsForwardPlanningNode node) {
        logger.info("Computing random successor for node {}", (Object)node);
        long start = System.currentTimeMillis();
        Monom state = node.getStateRelativeToInitState(this.initState);
        long timeToComputeState = System.currentTimeMillis() - start;
        List<StripsAction> applicableActions = StripsUtil.getApplicableActionsInState(state, this.problem.getDomain(), true, 2);
        logger.debug("Computation of applicable actions took {}ms of which {}ms were used to reproduce the state.", (Object)(System.currentTimeMillis() - start), (Object)timeToComputeState);
        return applicableActions.isEmpty() ? null : applicableActions.get(0);
    }

    public SingleSuccessorGenerator<StripsForwardPlanningNode, String> getSuccessorGenerator() {
        return new SingleSuccessorGenerator<StripsForwardPlanningNode, String>(){

            public List<NodeExpansionDescription<StripsForwardPlanningNode, String>> generateSuccessors(StripsForwardPlanningNode node) throws InterruptedException {
                if (StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node)) {
                    throw new IllegalArgumentException("Successors of node " + node + " have already been computed.");
                }
                long start = System.currentTimeMillis();
                ArrayList<NodeExpansionDescription<StripsForwardPlanningNode, String>> successors = new ArrayList<NodeExpansionDescription<StripsForwardPlanningNode, String>>();
                List applicableActions = StripsForwardPlanningGraphGenerator.this.getApplicableActionsInNode(node);
                StripsForwardPlanningGraphGenerator.this.returnedActions.put(node, applicableActions);
                for (StripsAction action : applicableActions) {
                    long t = System.currentTimeMillis();
                    Monom del = new Monom((Collection)node.getDel());
                    Monom add = new Monom((Collection)node.getAdd());
                    del.addAll((Collection)action.getDeleteList());
                    add.removeAll((Collection)action.getDeleteList());
                    add.addAll((Collection)action.getAddList());
                    StripsForwardPlanningNode newNode = new StripsForwardPlanningNode(add, del, action);
                    successors.add((NodeExpansionDescription<StripsForwardPlanningNode, String>)new NodeExpansionDescription((Object)node, (Object)newNode, (Object)"edge label", NodeType.OR));
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Created the node expansion description within {}ms. New state size is {}.", (Object)(System.currentTimeMillis() - t), (Object)newNode.getStateRelativeToInitState(StripsForwardPlanningGraphGenerator.this.initState).size());
                }
                logger.info("Generated {} successors in {}ms.", (Object)successors.size(), (Object)(System.currentTimeMillis() - start));
                StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.add(node);
                return successors;
            }

            public NodeExpansionDescription<StripsForwardPlanningNode, String> generateSuccessor(StripsForwardPlanningNode node, int i) throws InterruptedException {
                StripsAction action;
                if (StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node) && ((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).isEmpty()) {
                    return null;
                }
                long start = System.currentTimeMillis();
                assert (i >= 0) : "Index must not be negative!";
                if (StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node)) {
                    action = (StripsAction)((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).get(0);
                } else if (StripsForwardPlanningGraphGenerator.this.returnedActions.containsKey(node)) {
                    assert (!((List)StripsForwardPlanningGraphGenerator.this.returnedActions.get(node)).isEmpty());
                    assert (((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).isEmpty());
                    logger.debug("Generating {}th successor of {}", (Object)(((List)StripsForwardPlanningGraphGenerator.this.returnedActions.get(node)).size() + 1), (Object)node);
                    ArrayList returnedSolutionBak = new ArrayList((Collection)StripsForwardPlanningGraphGenerator.this.returnedActions.get(node));
                    this.generateSuccessors(node);
                    StripsForwardPlanningGraphGenerator.this.unreturnedActions.put(node, StripsForwardPlanningGraphGenerator.this.returnedActions.get(node));
                    StripsForwardPlanningGraphGenerator.this.returnedActions.put(node, returnedSolutionBak);
                    ((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).removeAll(returnedSolutionBak);
                    assert (StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node));
                    if (((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).isEmpty()) {
                        return null;
                    }
                    action = (StripsAction)((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).get(i % ((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).size());
                } else {
                    assert (!StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node));
                    assert (!StripsForwardPlanningGraphGenerator.this.returnedActions.containsKey(node));
                    assert (!StripsForwardPlanningGraphGenerator.this.unreturnedActions.containsKey(node));
                    action = StripsForwardPlanningGraphGenerator.this.getRandomApplicableActionInNode(node);
                    if (action == null) {
                        logger.debug("Apparently, the node {} has no successors.", (Object)node);
                        return null;
                    }
                    if (!StripsForwardPlanningGraphGenerator.this.unreturnedActions.containsKey(node)) {
                        StripsForwardPlanningGraphGenerator.this.unreturnedActions.put(node, new ArrayList());
                    }
                    ((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).add(action);
                    assert (!StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node));
                }
                assert (action != null);
                if (!StripsForwardPlanningGraphGenerator.this.returnedActions.containsKey(node)) {
                    StripsForwardPlanningGraphGenerator.this.returnedActions.put(node, new ArrayList());
                }
                ((List)StripsForwardPlanningGraphGenerator.this.returnedActions.get(node)).add(action);
                ((List)StripsForwardPlanningGraphGenerator.this.unreturnedActions.get(node)).remove(action);
                long t = System.currentTimeMillis();
                Monom del = new Monom((Collection)node.getDel());
                Monom add = new Monom((Collection)node.getAdd());
                del.addAll((Collection)action.getDeleteList());
                add.removeAll((Collection)action.getDeleteList());
                add.addAll((Collection)action.getAddList());
                StripsForwardPlanningNode newNode = new StripsForwardPlanningNode(add, del, action);
                NodeExpansionDescription successor = new NodeExpansionDescription((Object)node, (Object)newNode, (Object)"edge label", NodeType.OR);
                if (logger.isTraceEnabled()) {
                    logger.trace("Created the node expansion description within {}ms. New state size is {}.", (Object)(System.currentTimeMillis() - t), (Object)newNode.getStateRelativeToInitState(StripsForwardPlanningGraphGenerator.this.initState).size());
                }
                logger.info("Generated {}-th successor in {}ms.", (Object)i, (Object)(System.currentTimeMillis() - start));
                return successor;
            }

            public boolean allSuccessorsComputed(StripsForwardPlanningNode node) {
                return StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node);
            }
        };
    }

    public NodeGoalTester<StripsForwardPlanningNode> getGoalTester() {
        return l -> this.problem.getGoalStateFunction().isGoalState(l.getStateRelativeToInitState(this.initState));
    }

    public boolean isSelfContained() {
        return false;
    }

    public void setNodeNumbering(boolean nodenumbering) {
    }
}

