/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.ceoctfd;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDGraphGenerator;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.ceocstn.CEOCSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEOCTFDGraphGenerator
extends TFDGraphGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CEOCTFDGraphGenerator.class);

    public CEOCTFDGraphGenerator(CEOCSTNPlanningProblem problem) {
        super(problem);
    }

    @Override
    protected TFDNode postProcessPrimitiveTaskNode(TFDNode node) {
        Monom state = node.getState();
        state.getParameters().stream().filter(p -> p.getName().startsWith("newVar") && !state.contains((Object)new Literal("def('" + p.getName() + "')"))).forEach(p -> state.add((Object)new Literal("def('" + p.getName() + "')")));
        return node;
    }

    @Override
    public boolean isPathSemanticallySubsumed(List<TFDNode> path, List<TFDNode> compl) throws InterruptedException {
        if (compl.size() < path.size()) {
            logger.debug("Ignoring this partial path, because its completion is shorter than the path we already have.");
            return false;
        }
        if (path.equals(compl)) {
            logger.debug("Return true, because the paths are even equal.");
            return true;
        }
        HashMap<ConstantParam, ConstantParam> map = new HashMap<ConstantParam, ConstantParam>();
        boolean allUnifiable = true;
        for (int i = 0; i < path.size(); ++i) {
            Action a2;
            TFDNode current = path.get(i);
            TFDNode partner = compl.get(i);
            Action a1 = current.getAppliedAction();
            if (a1 == null != ((a2 = partner.getAppliedAction()) == null)) {
                allUnifiable = false;
                logger.trace("Not unifiable because one node applies an action and the other not (either it applies nothing or a method instance).");
                break;
            }
            if (a1 != null && !a1.getOperation().equals(a2.getOperation())) {
                allUnifiable = false;
                logger.trace("Not unifiable because operations {} and {} of a1 and a2 respectively deviate", (Object)a1.getOperation(), (Object)a2.getOperation());
                break;
            }
            if (a1 == null) {
                MethodInstance mi1 = current.getAppliedMethodInstance();
                MethodInstance mi2 = partner.getAppliedMethodInstance();
                if (mi1 == null && mi2 == null) continue;
                if (mi1 == null != (mi2 == null)) {
                    allUnifiable = false;
                    logger.trace("Not unifiable because one node applies a method instance and the other not (either an action or nothing)");
                    break;
                }
                if (!mi1.getMethod().equals(mi2.getMethod())) {
                    allUnifiable = false;
                    logger.trace("Not unifiable because methods {} and {} of m1 and m2 respectively deviate", (Object)mi1.getMethod(), (Object)mi2.getMethod());
                    break;
                }
            }
            HashSet varsInCurrent = new HashSet(current.getState().getConstantParams());
            for (Literal literal : current.getRemainingTasks()) {
                varsInCurrent.addAll(literal.getConstantParams());
            }
            HashSet varsInPartner = new HashSet(partner.getState().getConstantParams());
            for (Literal l3 : partner.getRemainingTasks()) {
                varsInPartner.addAll(l3.getConstantParams());
            }
            Collection collection = SetUtil.difference(varsInCurrent, map.keySet());
            Collection possibleTargets = SetUtil.difference(varsInPartner, map.values());
            for (ConstantParam p : new ArrayList(collection)) {
                if (!possibleTargets.contains(p)) continue;
                map.put(p, p);
                collection.remove(p);
                possibleTargets.remove(p);
            }
            if (collection.isEmpty()) {
                if (this.getRenamedState(current.getState(), map).equals((Object)partner.getState()) && this.getRenamedRemainingList(current.getRemainingTasks(), map).equals(partner.getRemainingTasks())) continue;
                allUnifiable = false;
                break;
            }
            boolean unified = false;
            Collection possibleMappingCompletions = SetUtil.allMappings((Collection)collection, (Collection)possibleTargets, (boolean)true, (boolean)true, (boolean)true);
            for (Map mappingCompletion : possibleMappingCompletions) {
                List<Literal> copyOfTasks;
                Monom copy = this.getRenamedState(current.getState(), mappingCompletion);
                if (!copy.equals((Object)partner.getState()) || !(copyOfTasks = this.getRenamedRemainingList(current.getRemainingTasks(), mappingCompletion)).equals(partner.getRemainingTasks())) continue;
                map.putAll(mappingCompletion);
                unified = true;
                break;
            }
            if (unified) continue;
            allUnifiable = false;
            break;
        }
        if (allUnifiable) {
            logger.info("Returning true, because this path is unifiable with the given one.");
            return true;
        }
        return false;
    }

    private Monom getRenamedState(Monom state, Map<ConstantParam, ConstantParam> map) {
        Monom copy = new Monom((Collection)state, map);
        return copy;
    }

    private List<Literal> getRenamedRemainingList(List<Literal> remainingList, Map<ConstantParam, ConstantParam> map) {
        ArrayList<Literal> copyOfTasks = new ArrayList<Literal>();
        for (Literal l : remainingList) {
            copyOfTasks.add(new Literal(l, map));
        }
        return copyOfTasks;
    }
}

