/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCAction;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.TaskPlannerUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn.RTNEdge;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn.RTNNode;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn.RTNUtil;
import ai.libs.jaicore.planning.hierarchical.problems.rtn.RTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.model.travesaltree.NodeExpansionDescription;
import ai.libs.jaicore.search.structure.graphgenerator.NodeGoalTester;
import ai.libs.jaicore.search.structure.graphgenerator.SingleRootGenerator;
import ai.libs.jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTNGraphGenerator
implements GraphGenerator<RTNNode, RTNEdge> {
    private static final Logger logger = LoggerFactory.getLogger(RTNGraphGenerator.class);
    private final RTNPlanningProblem problem;
    private final Map<String, Operation> primitiveTasks = new HashMap<String, Operation>();
    private final TaskPlannerUtil util = new TaskPlannerUtil(null);

    public RTNGraphGenerator(RTNPlanningProblem problem) {
        this.problem = problem;
        for (Operation operation : problem.getDomain().getOperations()) {
            this.primitiveTasks.put(operation.getName(), operation);
        }
    }

    public SingleRootGenerator<RTNNode> getRootGenerator() {
        return () -> new RTNNode(false, this.problem.getInit(), new ArrayList<Literal>(this.util.getTaskChainOfTotallyOrderedNetwork(this.problem.getNetwork())));
    }

    public SuccessorGenerator<RTNNode, RTNEdge> getSuccessorGenerator() {
        return l -> {
            ArrayList<NodeExpansionDescription<RTNNode, RTNEdge>> successors = new ArrayList<NodeExpansionDescription<RTNNode, RTNEdge>>();
            Monom state = l.getState();
            List<Literal> currentlyRemainingTasks = l.getRemainingTasks();
            Literal nextTaskTmp = currentlyRemainingTasks.get(0);
            if (nextTaskTmp == null) {
                return successors;
            }
            Literal nextTask = new Literal(nextTaskTmp.getPropertyName().substring(nextTaskTmp.getPropertyName().indexOf("-") + 1, nextTaskTmp.getPropertyName().length()), nextTaskTmp.getParameters());
            String actualTaskName = nextTask.getPropertyName();
            if (!l.isAndNode()) {
                if (this.primitiveTasks.containsKey(actualTaskName)) {
                    logger.info("Computing successors for PRIMITIVE task {} in state {}", (Object)nextTask, (Object)state);
                    Collection<Action> applicableActions = this.util.getActionsForPrimitiveTaskThatAreApplicableInState(null, this.primitiveTasks.get(actualTaskName), nextTask, state);
                    for (Action applicableAction : applicableActions) {
                        logger.info("Adding successor for PRIMITIVE task {} in state {}: {}", new Object[]{nextTask, state, applicableAction.getEncoding()});
                        assert (state.containsAll((Collection)applicableAction.getPrecondition().stream().filter(lit -> lit.isPositive()).collect(Collectors.toList())) && SetUtil.disjoint((Collection)state, (Collection)applicableAction.getPrecondition().stream().filter(lit -> lit.isNegated()).collect(Collectors.toList()))) : "Action " + applicableAction + " is supposed to be aplpicable in state " + state + " but it is not!";
                        Monom updatedState = new Monom((Collection)state, false);
                        CEOCOperation op = (CEOCOperation)applicableAction.getOperation();
                        CEOCAction relevantAction = new CEOCAction(op, applicableAction.getGrounding());
                        try {
                            StripsUtil.updateState(updatedState, applicableAction);
                        }
                        catch (Exception e) {
                            System.out.println("apply " + applicableAction.getEncoding() + " to state: " + state);
                            System.out.println("addlists: " + relevantAction.getAddLists());
                            e.printStackTrace();
                            System.exit(1);
                        }
                        ArrayList<Literal> remainingTasks = new ArrayList<Literal>(currentlyRemainingTasks);
                        remainingTasks.remove(0);
                        boolean isAndNode = this.remainingTasksInitializeANDNode(remainingTasks);
                        successors.add((NodeExpansionDescription<RTNNode, RTNEdge>)new NodeExpansionDescription(l, (Object)new RTNNode(isAndNode, updatedState, remainingTasks), (Object)new RTNEdge(null, null, relevantAction), null));
                    }
                    assert (RTNGraphGenerator.checkDoubleNodes(successors));
                    logger.info("Computed {} successors", (Object)successors.size());
                } else {
                    logger.info("Computing successors for COMPLEX task {} in state {}", (Object)nextTask, (Object)state);
                    HashSet<Method> usedMethods = new HashSet<Method>();
                    Collection<MethodInstance> instances = this.util.getMethodInstancesForTaskThatAreApplicableInState(null, this.problem.getDomain().getMethods(), nextTask, state, currentlyRemainingTasks);
                    for (MethodInstance instance : instances) {
                        if (!usedMethods.contains(instance.getMethod())) {
                            usedMethods.add(instance.getMethod());
                        } else if (instance.getMethod().isLonely()) continue;
                        assert (state.containsAll((Collection)instance.getPrecondition().stream().filter(lit -> lit.isPositive()).collect(Collectors.toList())) && SetUtil.disjoint((Collection)state, (Collection)instance.getPrecondition().stream().filter(lit -> lit.isNegated()).collect(Collectors.toList()))) : "Instance " + instance + " is supposed to be aplpicable in state " + state + " but it is not!";
                        logger.info("Adding successor {}", (Object)instance);
                        ArrayList<Literal> remainingTasks = new ArrayList<Literal>(this.util.getTaskChainOfTotallyOrderedNetwork(instance.getNetwork()));
                        int indexForRemoval = remainingTasks.size();
                        remainingTasks.addAll(currentlyRemainingTasks);
                        remainingTasks.remove(indexForRemoval);
                        boolean isAndNode = this.remainingTasksInitializeANDNode(remainingTasks);
                        successors.add((NodeExpansionDescription<RTNNode, RTNEdge>)new NodeExpansionDescription(l, (Object)new RTNNode(isAndNode, state, remainingTasks), (Object)new RTNEdge(null, instance, null), null));
                    }
                }
            } else {
                ArrayList<Literal> parallelizableTasks = new ArrayList<Literal>();
                ArrayList<Literal> tasksForLastNode = new ArrayList<Literal>(currentlyRemainingTasks);
                for (int i = 0; i < currentlyRemainingTasks.size(); ++i) {
                    Literal task = currentlyRemainingTasks.get(i);
                    if (!task.getPropertyName().contains("refine")) continue;
                    parallelizableTasks.add(task);
                    tasksForLastNode.remove(0);
                }
                for (Literal task : parallelizableTasks) {
                    Object lit22;
                    Monom reducedState = new Monom();
                    HashSet<ConstantParam> relevantConstants = new HashSet<ConstantParam>(task.getConstantParams());
                    for (String c : RTNUtil.getClassesThatExistInState(l)) {
                        relevantConstants.add(new ConstantParam(c));
                    }
                    for (Object lit22 : state) {
                        if (!relevantConstants.containsAll(lit22.getConstantParams())) continue;
                        reducedState.add(lit22);
                    }
                    HashMap<String, List<Object>> clusters = new HashMap<String, List<Object>>();
                    for (Literal lit3 : reducedState) {
                        if (!lit3.getPropertyName().equals("in")) continue;
                        String item = ((ConstantParam)lit3.getConstantParams().get(0)).getName();
                        String cluster = ((ConstantParam)lit3.getConstantParams().get(1)).getName();
                        if (!clusters.containsKey(cluster)) {
                            clusters.put(cluster, new ArrayList());
                        }
                        ((Collection)clusters.get(cluster)).add(item);
                    }
                    lit22 = clusters.keySet().iterator();
                    while (lit22.hasNext()) {
                        String cluster = (String)lit22.next();
                        clusters.put(cluster, ((Collection)clusters.get(cluster)).stream().sorted().collect(Collectors.toList()));
                    }
                    ArrayList<Literal> toRemove = new ArrayList<Literal>();
                    ArrayList<Literal> toInsert = new ArrayList<Literal>();
                    for (Literal lit4 : reducedState) {
                        if (lit4.getPropertyName().equals("biggest")) {
                            toRemove.add(lit4);
                            continue;
                        }
                        if (SetUtil.intersection((Collection)lit4.getConstantParams().stream().map(p -> p.getName()).collect(Collectors.toList()), clusters.keySet()).isEmpty()) continue;
                        toRemove.add(lit4);
                        ArrayList params = new ArrayList();
                        for (ConstantParam p2 : lit4.getConstantParams()) {
                            params.add(clusters.containsKey(p2.getName()) ? new ConstantParam(((Collection)clusters.get(p2.getName())).toString()) : p2);
                        }
                        toInsert.add(new Literal(lit4.getPropertyName(), (List)params));
                    }
                    reducedState.removeAll(toRemove);
                    reducedState.addAll(toInsert);
                    for (Literal lit4 : state) {
                        if (!lit4.getPropertyName().equals("bigger") || reducedState.contains((Object)lit4)) continue;
                        reducedState.add((Object)lit4);
                    }
                    ArrayList<Literal> remainingTask = new ArrayList<Literal>();
                    ArrayList<ConstantParam> paramsForTask = new ArrayList<ConstantParam>();
                    for (ConstantParam p3 : task.getConstantParams()) {
                        paramsForTask.add(clusters.containsKey(p3.getName()) ? new ConstantParam(((Collection)clusters.get(p3.getName())).toString()) : p3);
                    }
                    HashMap<ConstantParam, ConstantParam> mapping = new HashMap<ConstantParam, ConstantParam>();
                    for (String cluster : clusters.keySet()) {
                        mapping.put(new ConstantParam(((Collection)clusters.get(cluster)).toString()), new ConstantParam(cluster));
                    }
                    remainingTask.add(new Literal(task.getPropertyName().substring(task.getPropertyName().indexOf("-") + 1), paramsForTask));
                    successors.add((NodeExpansionDescription<RTNNode, RTNEdge>)new NodeExpansionDescription(l, (Object)new RTNNode(false, reducedState, remainingTask), (Object)new RTNEdge(mapping, null, null), null));
                }
                if (!tasksForLastNode.isEmpty()) {
                    successors.add((NodeExpansionDescription<RTNNode, RTNEdge>)new NodeExpansionDescription(l, (Object)new RTNNode(false, state, tasksForLastNode), (Object)new RTNEdge(null, null, null), null));
                }
            }
            logger.info("Computed {} successors", (Object)successors.size());
            return successors;
        };
    }

    public NodeGoalTester<RTNNode> getGoalTester() {
        return p -> p.getRemainingTasks().isEmpty();
    }

    private boolean remainingTasksInitializeANDNode(List<Literal> tasks) {
        if (tasks.isEmpty()) {
            return false;
        }
        Literal followingTask = tasks.get(0);
        return followingTask.getPropertyName().contains("refine");
    }

    private static boolean checkDoubleNodes(List<NodeExpansionDescription<RTNNode, RTNEdge>> successors) {
        if (successors.size() != new HashSet<NodeExpansionDescription<RTNNode, RTNEdge>>(successors).size()) {
            System.err.println("Doppelte Knoten im Nachfolger!");
            return false;
        }
        return true;
    }

    public boolean isSelfContained() {
        return false;
    }

    public void setNodeNumbering(boolean nodenumbering) {
    }
}

