/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.algorithms.strips.forward;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.AOptimizer;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.STRIPSForwardSearchReducer;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsForwardPlanningNode;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.classical.problems.strips.StripsOperation;
import ai.libs.jaicore.planning.classical.problems.strips.StripsPlanningProblem;
import ai.libs.jaicore.planning.core.EvaluatedPlan;
import ai.libs.jaicore.planning.core.Plan;
import ai.libs.jaicore.planning.core.events.PlanFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.BestFirst;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.core.interfaces.IPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STRIPSPlanner<V extends Comparable<V>>
extends AOptimizer<StripsPlanningProblem, EvaluatedPlan<V>, V> {
    private Logger logger = LoggerFactory.getLogger(STRIPSPlanner.class);
    private String loggerName;
    private final IPathInORGraphSearch<GraphSearchWithSubpathEvaluationsInput<StripsForwardPlanningNode, String, V>, EvaluatedSearchGraphPath<StripsForwardPlanningNode, String, V>, StripsForwardPlanningNode, String> search;
    private final INodeEvaluator<StripsForwardPlanningNode, V> nodeEvaluator;
    private final STRIPSForwardSearchReducer reducer = new STRIPSForwardSearchReducer();
    private boolean visualize = false;
    private final GraphGenerator<StripsForwardPlanningNode, String> graphGenerator;

    public STRIPSPlanner(StripsPlanningProblem problem, INodeEvaluator<StripsForwardPlanningNode, V> nodeEvaluator) {
        super((Object)problem);
        this.nodeEvaluator = nodeEvaluator;
        if (!problem.getInitState().getVariableParams().isEmpty()) {
            throw new IllegalArgumentException("The initial state contains variable parameters but must only contain constants!\nList of found variables: " + problem.getInitState().getVariableParams().stream().map(n -> "\n\t" + n.getName()).collect(Collectors.joining()));
        }
        if (!problem.getGoalState().getVariableParams().isEmpty()) {
            throw new IllegalArgumentException("The goal state contains variable parameters but must only contain constants!\nList of found variables: " + problem.getGoalState().getVariableParams().stream().map(n -> "\n\t" + n.getName()).collect(Collectors.joining()));
        }
        for (Operation o2 : problem.getDomain().getOperations()) {
            StripsOperation so = (StripsOperation)o2;
            Collection undeclaredParamsInPrecondition = SetUtil.difference((Collection)so.getPrecondition().getVariableParams(), so.getParams());
            if (!undeclaredParamsInPrecondition.isEmpty()) {
                throw new IllegalArgumentException("The precondition of operation " + so.getName() + " contains variables that are not defined in the parameter list: " + undeclaredParamsInPrecondition);
            }
            Collection undeclaredParamsInAddList = SetUtil.difference((Collection)so.getAddList().getVariableParams(), so.getParams());
            if (!undeclaredParamsInAddList.isEmpty()) {
                throw new IllegalArgumentException("The add list of operation " + so.getName() + " contains variables that are not defined in the parameter list: " + undeclaredParamsInAddList);
            }
            Collection undeclaredParamsInDelList = SetUtil.difference((Collection)so.getDeleteList().getVariableParams(), so.getParams());
            if (undeclaredParamsInDelList.isEmpty()) continue;
            throw new IllegalArgumentException("The del list of operation " + so.getName() + " contains variables that are not defined in the parameter list: " + undeclaredParamsInDelList);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing planner for the following problem:\n\tOperations:{}\n\tInitial State: {}\n\tGoal State: {}", new Object[]{problem.getDomain().getOperations().stream().map(o -> "\n\t - " + o.getName() + "\n\t\tParams: " + o.getParams() + "\n\t\tPre: " + o.getPrecondition() + "\n\t\tAdd: " + ((StripsOperation)o).getAddList() + "\n\t\tDel: " + ((StripsOperation)o).getDeleteList()).collect(Collectors.joining()), problem.getInitState(), problem.getGoalState()});
        }
        this.graphGenerator = this.reducer.encodeProblem(problem);
        GraphSearchWithSubpathEvaluationsInput searchProblem = new GraphSearchWithSubpathEvaluationsInput(this.graphGenerator, nodeEvaluator);
        this.search = new BestFirst(searchProblem);
    }

    public AlgorithmEvent nextWithException() throws AlgorithmExecutionCanceledException, InterruptedException, AlgorithmTimeoutedException, AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                this.setLoggerOfSearch();
                this.search.setTimeout(this.getTimeout());
                if (this.visualize) {
                    throw new UnsupportedOperationException("Currently no visualization supported!");
                }
                return this.activate();
            }
            case ACTIVE: {
                if (!this.search.hasNext()) {
                    return this.terminate();
                }
                try {
                    EvaluatedSearchGraphPath nextSolution = (EvaluatedSearchGraphPath)this.search.nextSolutionCandidate();
                    Plan plan = this.reducer.decodeSolution((SearchGraphPath<StripsForwardPlanningNode, String>)nextSolution);
                    EvaluatedPlan<Comparable> evaluatedPlan = new EvaluatedPlan<Comparable>(plan, nextSolution.getScore());
                    this.updateBestSeenSolution(evaluatedPlan);
                    return new PlanFoundEvent(this.getId(), evaluatedPlan);
                }
                catch (NoSuchElementException e) {
                    return this.terminate();
                }
            }
        }
        throw new IllegalStateException("Cannot handle algorithm state " + this.getState());
    }

    public void enableVisualization() {
        this.visualize = true;
    }

    public void cancel() {
        super.cancel();
        if (this.search != null) {
            this.search.cancel();
        }
    }

    private void setLoggerOfSearch() {
        if (this.search != null && this.loggerName != null) {
            if (this.search instanceof ILoggingCustomizable) {
                this.logger.info("Switching logger of search to {}.search", (Object)this.getLoggerName());
                ((ILoggingCustomizable)this.search).setLoggerName(this.getLoggerName() + ".search");
            } else {
                this.logger.info("The search is of class {}, which is not logging customizable.", this.search.getClass());
            }
        } else {
            this.logger.info("Not yet setting logger of search, since search has not yet been configured.");
        }
    }

    public GraphGenerator<StripsForwardPlanningNode, String> getGraphGenerator() {
        return this.graphGenerator;
    }

    public void setLoggerName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Logger name must not be set to null.");
        }
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.nodeEvaluator instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.nodeEvaluator).setLoggerName(name + ".nodeeval");
        }
        this.setLoggerOfSearch();
        super.setLoggerName(this.loggerName + "._planningalgorithm");
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

