/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.algorithms.strips.forward;

import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Clause;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.ForwardChainer;
import ai.libs.jaicore.logic.fol.util.ForwardChainingProblem;
import ai.libs.jaicore.logic.fol.util.NextBindingFoundEvent;
import ai.libs.jaicore.planning.classical.problems.ce.CEAction;
import ai.libs.jaicore.planning.classical.problems.ce.CEOperation;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.classical.problems.strips.StripsAction;
import ai.libs.jaicore.planning.classical.problems.strips.StripsOperation;
import ai.libs.jaicore.planning.classical.problems.strips.StripsPlanningDomain;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.core.Plan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripsUtil {
    private static final Logger logger = LoggerFactory.getLogger(StripsUtil.class);

    public static List<StripsAction> getApplicableActionsInState(Monom state, StripsPlanningDomain domain) {
        return StripsUtil.getApplicableActionsInState(state, domain, false, -1);
    }

    public static List<StripsAction> getApplicableActionsInState(Monom state, StripsPlanningDomain domain, boolean randomized, int pLimit) {
        long start = System.currentTimeMillis();
        int limit = pLimit;
        logger.debug("Computing applicable actions for state with {} items (activate TRACE for exact state)", (Object)state.size());
        logger.trace("Exact state is {}", (Object)state);
        ArrayList<StripsAction> applicableDerivedActions = new ArrayList<StripsAction>();
        Collection<Operation> operations = domain.getOperations();
        if (randomized) {
            if (!(operations instanceof List)) {
                operations = new ArrayList<Operation>(operations);
            }
            Collections.shuffle((List)operations);
        }
        long timeToOrderOps = System.currentTimeMillis() - start;
        for (Operation op : domain.getOperations()) {
            Collection<StripsAction> candidates = StripsUtil.getPossibleOperationGroundingsForState(state, (StripsOperation)op, limit);
            applicableDerivedActions.addAll(candidates);
            if (limit < 0) continue;
            limit = Math.max(0, limit - candidates.size());
        }
        long duration = System.currentTimeMillis() - start;
        logger.debug("Done. Computation of {} applicable actions took {}ms of which {}ms were used to order the operations", new Object[]{applicableDerivedActions.size(), duration, timeToOrderOps});
        return applicableDerivedActions;
    }

    public static Collection<StripsAction> getPossibleOperationGroundingsForState(Monom state, StripsOperation operation, int limit) {
        ArrayList<StripsAction> applicableDerivedActions = new ArrayList<StripsAction>();
        logger.debug("Compute all groundings of {}-premise that can be inferred from state with {} items (activate TRACE for exact premise and state)", (Object)operation.getPrecondition().size(), (Object)state.size());
        logger.trace("Exact premise is {}", (Object)operation.getPrecondition());
        logger.trace("Exact state is {}", (Object)state);
        long start = System.currentTimeMillis();
        ForwardChainer fc = new ForwardChainer(new ForwardChainingProblem(state, operation.getPrecondition(), true));
        long fcPreparationTime = System.currentTimeMillis() - start;
        try {
            NextBindingFoundEvent event;
            int i = 0;
            while ((event = fc.nextBinding()) != null && (limit < 0 || i++ < limit)) {
                Map grounding = event.getGrounding();
                HashMap<VariableParam, ConstantParam> rGrounding = new HashMap<VariableParam, ConstantParam>();
                for (VariableParam p : grounding.keySet()) {
                    ConstantParam cp = (ConstantParam)grounding.get(p);
                    rGrounding.put(p, cp);
                }
                StripsAction a = new StripsAction(operation, rGrounding);
                applicableDerivedActions.add(a);
                logger.debug("Found action {} to be applicable after {}ms.", (Object)a.getEncoding(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("Determined {}/{} applicable actions within {}ms of which preparing the FC algorithm consumed {}ms.", new Object[]{applicableDerivedActions.size(), limit, System.currentTimeMillis() - start, fcPreparationTime});
        return applicableDerivedActions;
    }

    public static void updateState(Monom state, Action appliedAction) {
        if (appliedAction.getOperation() instanceof StripsOperation) {
            StripsAction a = new StripsAction((StripsOperation)appliedAction.getOperation(), appliedAction.getGrounding());
            state.removeAll((Collection)a.getDeleteList());
            state.addAll((Collection)a.getAddList());
        } else if (appliedAction.getOperation() instanceof CEOperation) {
            CEAction a = new CEAction((CEOperation)appliedAction.getOperation(), appliedAction.getGrounding());
            Map<CNFFormula, Monom> addLists = a.getAddLists();
            Map<CNFFormula, Monom> deleteLists = a.getDeleteLists();
            ArrayList toRemove = new ArrayList();
            for (CNFFormula condition : deleteLists.keySet()) {
                if (!condition.entailedBy(state)) continue;
                toRemove.addAll((Collection)deleteLists.get(condition));
            }
            ArrayList toAdd = new ArrayList();
            for (CNFFormula condition : addLists.keySet()) {
                CNFFormula modifiedCondition = new CNFFormula();
                boolean conditionIsSatisfiable = true;
                block2: for (Clause c : condition) {
                    Clause modifiedClause = new Clause();
                    boolean clauseContainsTrue = false;
                    for (Literal l : c) {
                        modifiedClause.add((Object)l);
                        if (clauseContainsTrue) continue;
                        if (!modifiedClause.isEmpty()) {
                            modifiedCondition.add((Object)modifiedClause);
                            continue;
                        }
                        conditionIsSatisfiable = false;
                        continue block2;
                    }
                }
                if (!conditionIsSatisfiable || !modifiedCondition.entailedBy(state)) continue;
                toAdd.addAll((Collection)addLists.get(condition));
            }
            state.removeAll(toRemove);
            state.addAll(toAdd);
        } else {
            System.err.println("No support for operations of class " + appliedAction.getOperation().getClass());
        }
    }

    public static Monom getStateAfterPlanExecution(Monom initState, Plan plan) {
        Monom state = new Monom((Collection)initState);
        plan.getActions().forEach(a -> StripsUtil.updateState(state, a));
        return state;
    }

    public static void main(String[] args) {
        System.out.println("NON-PRIMITIVE!");
    }
}

