/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.core;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Action
implements Serializable {
    private static final long serialVersionUID = -2685277085885131650L;
    private final Operation operation;
    private final Map<VariableParam, ConstantParam> grounding;

    public Action(Operation operation, Map<VariableParam, ConstantParam> grounding) {
        this.operation = operation;
        this.grounding = grounding;
        if (!this.grounding.keySet().containsAll(operation.getParams())) {
            throw new IllegalArgumentException("Planning actions must contain a grounding for ALL params of the operation " + operation.getName() + ". Here, op params: " + operation.getParams() + ". Given grounding: " + grounding);
        }
    }

    public List<ConstantParam> getParameters() {
        return this.operation.getParams().stream().map(p -> this.grounding.get(p)).collect(Collectors.toList());
    }

    public Map<VariableParam, ConstantParam> getGrounding() {
        return this.grounding;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Monom getPrecondition() {
        return new Monom((Collection)this.operation.getPrecondition(), this.grounding);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.grounding == null ? 0 : this.grounding.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (this.grounding == null ? other.grounding != null : !this.grounding.equals(other.grounding)) {
            return false;
        }
        return !(this.operation == null ? other.operation != null : !this.operation.equals(other.operation));
    }

    public String getEncoding() {
        StringBuilder b = new StringBuilder();
        b.append(this.operation.getName());
        b.append("(");
        List<VariableParam> params = this.operation.getParams();
        int size = params.size();
        for (int i = 0; i < params.size(); ++i) {
            b.append(this.grounding.get(params.get(i)));
            if (i >= size - 1) continue;
            b.append(", ");
        }
        b.append(")");
        return b.toString();
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("operation", this.operation);
        fields.put("grounding", this.grounding);
        return ToJSONStringUtil.toJSONString(fields);
    }
}

