/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.AOptimizer;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.core.EvaluatedSearchGraphBasedPlan;
import ai.libs.jaicore.planning.core.Plan;
import ai.libs.jaicore.planning.core.events.PlanFoundEvent;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHierarchicalPlanningGraphGeneratorDeriver;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearchFactory;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import ai.libs.jaicore.search.probleminputs.builders.SearchProblemInputBuilder;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSearchBasedHTNPlanningAlgorithm<P extends IHTNPlanningProblem, S extends GraphSearchInput<N, A>, N, A, V extends Comparable<V>>
extends AOptimizer<P, EvaluatedSearchGraphBasedPlan<V, N>, V> {
    private Logger logger = LoggerFactory.getLogger(GraphSearchBasedHTNPlanningAlgorithm.class);
    private String loggerName;
    private final IHierarchicalPlanningGraphGeneratorDeriver<P, N, A> problemTransformer;
    private final IOptimalPathInORGraphSearch<S, N, A, V> search;

    public GraphSearchBasedHTNPlanningAlgorithm(P problem, IHierarchicalPlanningGraphGeneratorDeriver<P, N, A> problemTransformer, IOptimalPathInORGraphSearchFactory<S, N, A, V> searchFactory, SearchProblemInputBuilder<N, A, S> searchProblemBuilder) {
        super(problem);
        this.problemTransformer = problemTransformer;
        searchProblemBuilder.setGraphGenerator(((GraphSearchInput)problemTransformer.encodeProblem(problem)).getGraphGenerator());
        this.search = searchFactory.getAlgorithm(searchProblemBuilder.build());
    }

    public List<Action> getPlan(List<TFDNode> path) {
        return path.stream().filter(n -> n.getAppliedAction() != null).map(TFDNode::getAppliedAction).collect(Collectors.toList());
    }

    public void cancel() {
        super.cancel();
        this.getSearch().cancel();
    }

    public AlgorithmEvent nextWithException() throws AlgorithmExecutionCanceledException, InterruptedException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.debug("I'm being asked whether there is a next solution.");
        switch (this.getState()) {
            case CREATED: {
                this.logger.info("Starting HTN planning process.");
                if (this.logger.isDebugEnabled()) {
                    StringBuilder opSB = new StringBuilder();
                    for (Operation operation : ((IHTNPlanningProblem)this.getInput()).getDomain().getOperations()) {
                        opSB.append("\n\t\t");
                        opSB.append(operation);
                    }
                    StringBuilder methodSB = new StringBuilder();
                    for (Method method : ((IHTNPlanningProblem)this.getInput()).getDomain().getMethods()) {
                        methodSB.append("\n\t\t");
                        methodSB.append(method);
                    }
                    this.logger.debug("The HTN problem is defined as follows:\n\tOperations:{}\n\tMethods:{}", (Object)opSB, (Object)methodSB);
                }
                TimeOut to = this.getTimeout();
                this.logger.debug("Setting timeout of search to {}", (Object)to);
                this.search.setTimeout(to);
                return this.activate();
            }
            case ACTIVE: {
                if (this.isCanceled()) {
                    throw new IllegalStateException("The planner has already been canceled. Cannot compute more plans.");
                }
                this.logger.info("Starting/continuing search for next plan.");
                try {
                    EvaluatedSearchGraphPath solution = (EvaluatedSearchGraphPath)this.search.nextSolutionCandidate();
                    if (solution == null) {
                        this.logger.info("No more solutions will be found. Terminating algorithm.");
                        return this.terminate();
                    }
                    this.logger.info("Next solution found.");
                    Plan plan = (Plan)this.problemTransformer.decodeSolution(solution);
                    PlanFoundEvent planFoundEvent = new PlanFoundEvent(this.getId(), new EvaluatedSearchGraphBasedPlan(plan.getActions(), solution.getScore(), solution));
                    this.post((Object)planFoundEvent);
                    return planFoundEvent;
                }
                catch (NoSuchElementException e) {
                    return this.terminate();
                }
            }
        }
        throw new IllegalStateException("Don't know what to do in state " + this.getState());
    }

    public IOptimalPathInORGraphSearch<S, N, A, V> getSearch() {
        return this.search;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.problemTransformer instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of problem transformer to {}.problemtransformer", (Object)name);
            ((ILoggingCustomizable)this.problemTransformer).setLoggerName(name + ".problemtransformer");
        }
        if (this.search instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of search to {}.search", (Object)name);
            ((ILoggingCustomizable)this.search).setLoggerName(name + ".search");
        }
        super.setLoggerName(this.loggerName + "._algorithm");
    }
}

