/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDRestProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class TFDNode
implements Serializable {
    private static final long serialVersionUID = 7710905829501897491L;
    private TFDRestProblem problem;
    private final MethodInstance appliedMethodInstance;
    private final Action appliedAction;
    private final boolean isGoal;

    public TFDNode(Monom initialState, List<Literal> remainingTasks) {
        this(initialState, remainingTasks, null, null);
    }

    public TFDNode(MethodInstance appliedMethodInstance, boolean isGoal) {
        this.problem = null;
        this.appliedMethodInstance = appliedMethodInstance;
        this.appliedAction = null;
        this.isGoal = isGoal;
    }

    public TFDNode(Action appliedAction, boolean isGoal) {
        this.problem = null;
        this.appliedAction = appliedAction;
        this.appliedMethodInstance = null;
        this.isGoal = isGoal;
    }

    public TFDNode(Monom state, List<Literal> remainingTasks, MethodInstance appliedMethodInstance, Action appliedAction) {
        this.problem = new TFDRestProblem(state, remainingTasks);
        this.appliedMethodInstance = appliedMethodInstance;
        this.appliedAction = appliedAction;
        this.isGoal = remainingTasks.isEmpty();
    }

    public TFDRestProblem getProblem() {
        return this.problem;
    }

    public Monom getState() {
        return this.problem.getState();
    }

    public List<Literal> getRemainingTasks() {
        return this.problem.getRemainingTasks();
    }

    public Action getAppliedAction() {
        return this.appliedAction;
    }

    public MethodInstance getAppliedMethodInstance() {
        return this.appliedMethodInstance;
    }

    public boolean isGoal() {
        return this.isGoal;
    }

    public void clear() {
        this.problem = null;
    }

    public String toString() {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("isGoal", Boolean.valueOf(this.isGoal));
        fields.put("problem", this.problem);
        fields.put("appliedMethodInstance", this.appliedMethodInstance);
        fields.put("appliedAction", this.appliedAction);
        return ToJSONStringUtil.toJSONString((String)"TFDNode", fields);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appliedAction == null ? 0 : this.appliedAction.hashCode());
        result = 31 * result + (this.appliedMethodInstance == null ? 0 : this.appliedMethodInstance.hashCode());
        result = 31 * result + (this.isGoal ? 1231 : 1237);
        result = 31 * result + (this.problem == null ? 0 : this.problem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TFDNode other = (TFDNode)obj;
        if (this.appliedAction == null ? other.appliedAction != null : !this.appliedAction.equals(other.appliedAction)) {
            return false;
        }
        if (this.appliedMethodInstance == null ? other.appliedMethodInstance != null : !this.appliedMethodInstance.equals(other.appliedMethodInstance)) {
            return false;
        }
        if (this.isGoal != other.isGoal) {
            return false;
        }
        return !(this.problem == null ? other.problem != null : !this.problem.equals(other.problem));
    }
}

