/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.converters;

import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class CEOCIPSTN2JSHOP2 {
    public static void printDomain(CEOCIPSTNPlanningProblem problem, Writer writer, String name) throws IOException {
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write("(defdomain " + name + "\n " + CEOCIPSTN2JSHOP2.indent(1) + " (\n");
        bw.flush();
        bw.write(CEOCIPSTN2JSHOP2.indent(1) + ")\n");
        bw.write(")");
        bw.flush();
    }

    public static void printOperation(BufferedWriter bw, CEOCOperation operation, int i) throws IOException {
        Monom addList;
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + "(:operator (!" + CEOCIPSTN2JSHOP2.maskString(operation.getName()));
        operation.getParams().stream().forEach(param -> {
            try {
                bw.write(" ?" + param.getName());
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n ");
        CEOCIPSTN2JSHOP2.printMonom(bw, operation.getPrecondition(), i + 1);
        Map<CNFFormula, Monom> deleteLists = operation.getDeleteLists();
        boolean containsUnconditionalDelete = deleteLists.containsKey(new CNFFormula());
        if (deleteLists.size() > 1 || deleteLists.size() == 1 && !containsUnconditionalDelete) {
            throw new IllegalArgumentException("The operation " + operation.getName() + " contains conditional deletes, which cannot be converted to JSHOP2 format.");
        }
        Monom deleteList = containsUnconditionalDelete ? deleteLists.get(new CNFFormula()) : new Monom();
        CEOCIPSTN2JSHOP2.printMonom(bw, deleteList, i + 1);
        Map<CNFFormula, Monom> addLists = operation.getAddLists();
        boolean containsUnconditionalAdd = deleteLists.containsKey(new CNFFormula());
        Monom monom = addList = containsUnconditionalAdd ? addLists.get(new CNFFormula()) : new Monom();
        if (addLists.size() > 1 || addLists.size() == 1 && !containsUnconditionalAdd) {
            throw new IllegalArgumentException("The operation " + operation.getName() + " contains conditional adds, which cannot be converted to JSHOP2 format.");
        }
        CEOCIPSTN2JSHOP2.printMonom(bw, addList, i + 1);
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + ")\n\n");
        bw.flush();
    }

    public static void printMonom(BufferedWriter bw, Monom monom, int i) throws IOException {
        CEOCIPSTN2JSHOP2.printMonom(bw, monom, i, false);
    }

    public static void printMonom(BufferedWriter bw, Monom monom, int i, boolean newline) throws IOException {
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + "(");
        monom.stream().forEach(lit -> {
            try {
                CEOCIPSTN2JSHOP2.printLiteral(bw, lit);
                if (newline) {
                    bw.write("\n" + CEOCIPSTN2JSHOP2.indent(i) + " ");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bw.write(")\n");
        bw.flush();
    }

    public static void printLiteral(BufferedWriter bw, Literal lit) throws IOException {
        bw.write(" (");
        boolean negated = lit.isNegated();
        if (negated) {
            bw.write("not(");
        }
        bw.write(CEOCIPSTN2JSHOP2.maskString(lit.getPropertyName()));
        lit.getParameters().forEach(param -> {
            try {
                bw.write(" ?" + CEOCIPSTN2JSHOP2.maskString(param.getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        if (negated) {
            bw.write(")");
        }
        bw.write(")");
        bw.flush();
    }

    public static void printMethod(BufferedWriter bw, Method method, int i) throws IOException {
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + "(:method");
        CEOCIPSTN2JSHOP2.printLiteral(bw, method.getTask());
        bw.write("\n");
        bw.write(CEOCIPSTN2JSHOP2.indent(i + 1) + method.getName());
        bw.write("\n");
        CEOCIPSTN2JSHOP2.printMonom(bw, method.getPrecondition(), i + 1);
        CEOCIPSTN2JSHOP2.printNetwork(bw, method.getNetwork(), i + 1);
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + ")\n");
        bw.flush();
    }

    private static void printNetwork(BufferedWriter bw, TaskNetwork network, int i) throws IOException {
        bw.write(CEOCIPSTN2JSHOP2.indent(i) + "(");
        Literal next = (Literal)network.getRoot();
        while (next != null) {
            CEOCIPSTN2JSHOP2.printLiteral(bw, next);
            Iterator it = network.getSuccessors(next).iterator();
            next = it.hasNext() ? (Literal)it.next() : null;
        }
        bw.write(")\n");
    }

    public static void printProblem(CEOCIPSTNPlanningProblem problem, Writer writer, String name) throws IOException {
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write("(defproblem problem " + name + "\n");
        bw.write(CEOCIPSTN2JSHOP2.indent(1) + "(\n");
        CEOCIPSTN2JSHOP2.printMonom(bw, problem.getInit(), 2, true);
        bw.write(CEOCIPSTN2JSHOP2.indent(1) + ")\n");
        bw.write(CEOCIPSTN2JSHOP2.indent(1) + "(\n");
        CEOCIPSTN2JSHOP2.printNetwork(bw, problem.getNetwork(), 2);
        bw.write(CEOCIPSTN2JSHOP2.indent(1) + ")\n");
        bw.write(")");
        bw.flush();
    }

    public static String maskString(String str) {
        str = str.replaceAll("\\.", "_");
        str = str.replaceAll(":", "__");
        str = str.replaceAll("<", "___");
        str = str.replaceAll(">", "___");
        str = str.replaceAll("\\[\\]", "Array");
        return str;
    }

    public static String indent(int numberOfIntends) {
        String r = "";
        for (int i = 0; i < numberOfIntends; ++i) {
            r = r + "\t";
        }
        return r;
    }
}

