/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.stn;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.STNPlanningDomain;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.util.HashMap;

public class STNPlanningProblem
implements IHTNPlanningProblem {
    private final STNPlanningDomain domain;
    private final CNFFormula knowledge;
    private final Monom init;
    private final TaskNetwork network;
    private final boolean sortNetworkBasedOnNumberPrefixes = true;

    public STNPlanningProblem(STNPlanningDomain domain, CNFFormula knowledge, Monom init, TaskNetwork network) {
        this.domain = domain;
        this.knowledge = knowledge;
        this.init = init;
        this.network = network;
    }

    @Override
    public STNPlanningDomain getDomain() {
        return this.domain;
    }

    @Override
    public CNFFormula getKnowledge() {
        return this.knowledge;
    }

    @Override
    public Monom getInit() {
        return this.init;
    }

    @Override
    public TaskNetwork getNetwork() {
        return this.network;
    }

    public boolean isSortNetworkBasedOnNumberPrefixes() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.init == null ? 0 : this.init.hashCode());
        result = 31 * result + (this.knowledge == null ? 0 : this.knowledge.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + 1231;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        STNPlanningProblem other = (STNPlanningProblem)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.init == null ? other.init != null : !this.init.equals((Object)other.init)) {
            return false;
        }
        if (this.knowledge == null ? other.knowledge != null : !this.knowledge.equals((Object)other.knowledge)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals((Object)other.network)) {
            return false;
        }
        return true == other.sortNetworkBasedOnNumberPrefixes;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("domain", this.domain);
        fields.put("knowledge", this.knowledge);
        fields.put("init", this.init);
        fields.put("network", (Object)this.network);
        fields.put("sortNetworkBasedOnNumberPrefixes", this.sortNetworkBasedOnNumberPrefixes);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

