/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.stn;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.graph.Graph;
import ai.libs.jaicore.logic.fol.structure.Literal;
import java.util.List;

public class TaskNetwork
extends Graph<Literal> {
    public TaskNetwork() {
    }

    public TaskNetwork(List<Literal> chain) {
        int n = chain.size();
        Literal prev = null;
        for (int i = 0; i < n; ++i) {
            Literal cur = chain.get(i);
            this.addItem(cur);
            if (prev != null) {
                this.addEdge(prev, cur);
            }
            prev = cur;
        }
    }

    public TaskNetwork(Graph<Literal> graph) {
        super(graph);
    }

    public TaskNetwork(String chain) {
        Literal current = null;
        int id = 1;
        for (String taskDescription : StringUtil.explode((String)chain, (String)"->")) {
            if (taskDescription.trim().isEmpty()) continue;
            Literal task = new Literal("tn_" + id + "-" + taskDescription.trim());
            this.addItem(task);
            if (current != null) {
                this.addEdge(current, task);
            }
            current = task;
            ++id;
        }
    }
}

