/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.problems.strips;

import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.problems.strips.GoalStateFunction;
import ai.libs.jaicore.planning.classical.problems.strips.PlanningDomain;
import java.util.Collection;

public class PlanningProblem {
    private final PlanningDomain domain;
    private final Monom initState;
    private final Monom goalState;
    private final GoalStateFunction goalStateFunction;

    public PlanningProblem(PlanningDomain domain, Monom initState, Monom goalState) {
        this.domain = domain;
        this.initState = initState;
        this.goalState = goalState;
        this.goalStateFunction = s -> s.containsAll((Collection)goalState);
    }

    public PlanningProblem(PlanningDomain domain, Monom initState, GoalStateFunction goalStateFunction) {
        this.domain = domain;
        this.initState = initState;
        this.goalStateFunction = goalStateFunction;
        this.goalState = null;
    }

    public PlanningDomain getDomain() {
        return this.domain;
    }

    public Monom getInitState() {
        return this.initState;
    }

    public GoalStateFunction getGoalStateFunction() {
        return this.goalStateFunction;
    }

    public Monom getGoalState() {
        return this.goalState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.goalStateFunction == null ? 0 : this.goalStateFunction.hashCode());
        result = 31 * result + (this.initState == null ? 0 : this.initState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanningProblem other = (PlanningProblem)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.goalStateFunction == null ? other.goalStateFunction != null : !this.goalStateFunction.equals(other.goalStateFunction)) {
            return false;
        }
        return !(this.initState == null ? other.initState != null : !this.initState.equals((Object)other.initState));
    }

    public String toString() {
        return "PlanningProblem [domain=" + this.domain + ", initState=" + this.initState + ", goalStateFunction=" + this.goalStateFunction + "]";
    }
}

