/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms;

import ai.libs.jaicore.basic.algorithm.IAlgorithmFactory;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.core.interfaces.IEvaluatedGraphSearchBasedPlan;
import ai.libs.jaicore.planning.hierarchical.algorithms.CostSensitiveGraphSearchBasedPlanningAlgorithm;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import org.slf4j.Logger;

public class CostSensitiveGraphSearchBasedHTNPlanningAlgorithm<P extends IHTNPlanningProblem, S extends GraphSearchInput<N, A>, N, A, V extends Comparable<V>>
extends CostSensitiveGraphSearchBasedPlanningAlgorithm<P, S, N, A, V> {
    public CostSensitiveGraphSearchBasedHTNPlanningAlgorithm(P problem, AlgorithmicProblemReduction<P, IEvaluatedGraphSearchBasedPlan<N, A, V>, S, EvaluatedSearchGraphPath<N, A, V>> problemTransformer, IAlgorithmFactory<S, EvaluatedSearchGraphPath<N, A, V>> baseFactory) {
        super(problem, problemTransformer, baseFactory);
    }

    public void runPreCreationHook() {
        Logger logger = this.getLogger();
        logger.info("Starting HTN planning process.");
        if (logger.isDebugEnabled()) {
            StringBuilder opSB = new StringBuilder();
            for (Operation operation : ((IHTNPlanningProblem)this.getInput()).getDomain().getOperations()) {
                opSB.append("\n\t\t");
                opSB.append(operation);
            }
            StringBuilder methodSB = new StringBuilder();
            for (Method method : ((IHTNPlanningProblem)this.getInput()).getDomain().getMethods()) {
                methodSB.append("\n\t\t");
                methodSB.append(method);
            }
            logger.debug("The HTN problem is defined as follows:\n\tOperations:{}\n\tMethods:{}", (Object)opSB, (Object)methodSB);
        }
    }
}

