/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.ceocstn.converters;

import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.hierarchical.problems.ceocstn.CEOCSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.AShop2Converter;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;

public class CEOCSTN2Shop2
extends AShop2Converter {
    private String packageName;

    public void printDomain(File output) throws IOException {
        FileWriter fileWriter = new FileWriter(output);
        try (BufferedWriter bw = new BufferedWriter(fileWriter);){
            String fileName = output.getName();
            fileName = fileName.substring(0, fileName.indexOf(46)).toLowerCase();
            if (!this.packageName.isEmpty()) {
                bw.write("(int-package : " + this.packageName + ")");
                bw.flush();
            }
            bw.write("(defun define-" + fileName + "-domain()\n");
            bw.write(this.indent(1) + "(let (( * define-silently* t))\n");
            bw.flush();
            bw.write(this.indent(1) + "(defdomain (" + fileName + " :redinfe-ok t)(\n");
            bw.flush();
            bw.write(this.indent(1) + ")\n");
            bw.write("\t)\n)");
            bw.flush();
        }
    }

    public void printOperation(BufferedWriter bw, CEOCOperation operation, int i) throws IOException {
        bw.write(this.indent(i) + "(:operator (!" + operation.getName());
        for (VariableParam param : operation.getParams()) {
            bw.write(" ?" + param.getName());
            bw.flush();
        }
        bw.write(")\n ");
        this.printMonom(bw, operation.getPrecondition(), 4);
        this.printMonomMap(bw, operation.getDeleteLists(), 4);
        this.printMonomMap(bw, operation.getAddLists(), 4);
        bw.write(this.indent(i) + ")\n\n");
        bw.flush();
    }

    private void printMonomMap(BufferedWriter bw, Map<CNFFormula, Monom> map, int i) throws IOException {
        for (Monom member : map.values()) {
            this.printMonom(bw, member, i);
        }
        bw.flush();
    }

    @Override
    public void printLiteral(BufferedWriter bw, Literal lit) throws IOException {
        bw.write(" (");
        bw.write(lit.getProperty());
        for (LiteralParam param : lit.getParameters()) {
            bw.write(" ?" + param.getName());
        }
        bw.write(")");
        bw.flush();
    }

    public void printMethod(BufferedWriter bw, Method method, int i) throws IOException {
        bw.write(this.indent(i) + "(:method (" + method.getName());
        for (LiteralParam literalParam : method.getParameters()) {
            bw.write(" ?" + literalParam.getName());
        }
        bw.write(")\n");
        this.printMonom(bw, method.getPrecondition(), i + 1);
        this.printNetwork(bw, (Literal)method.getNetwork().getRoot(), method.getNetwork(), true, 4);
        bw.write(this.indent(i) + ")\n");
        bw.flush();
    }

    private void printNetwork(BufferedWriter bw, Literal lit, TaskNetwork network, boolean ordered, int i) throws IOException {
        bw.write(this.indent(i) + "(");
        if (lit.equals(network.getRoot())) {
            if (ordered) {
                bw.write(":ordered\n");
            } else {
                bw.write(":unordered\n");
            }
        }
        bw.write(this.indent(i + 1) + "(" + lit.getProperty());
        bw.flush();
        for (LiteralParam param : lit.getParameters()) {
            bw.write(" ?" + param.getName());
        }
        bw.write(")\n");
        for (Literal literal : network.getSuccessors(lit)) {
            this.printNetwork(bw, literal, i + 1);
        }
        bw.write(this.indent(i) + ")\n");
        bw.flush();
    }

    private void printNetwork(BufferedWriter bw, Literal lit, int i) throws IOException {
        bw.write(this.indent(i) + "(" + lit.getProperty());
        for (LiteralParam param : lit.getParameters()) {
            bw.write(" ?" + param.getName());
        }
        bw.write(")\n");
    }

    public void printProblem(CEOCSTNPlanningProblem problem, File output) throws IOException {
        FileWriter fileWriter = new FileWriter(output);
        try (BufferedWriter bw = new BufferedWriter(fileWriter);){
            String fileName = output.getName();
            fileName = fileName.substring(0, fileName.indexOf(46)).toLowerCase();
            if (!this.packageName.isEmpty()) {
                bw.write("(int-package : " + this.packageName + ")");
                bw.flush();
            }
            bw.write("(make-problem '" + fileName + "'-01 ' " + fileName + "\n");
            bw.write(this.indent(1) + "(\n");
            this.printMonom(bw, problem.getInit(), 2, true);
            this.printNetwork(bw, (Literal)problem.getNetwork().getRoot(), 2);
            bw.write(this.indent(1) + ")\n");
            bw.write(")");
            bw.flush();
        }
    }

    public void print(CEOCSTNPlanningProblem problem) throws IOException {
        this.print(problem, "");
    }

    public void print(CEOCSTNPlanningProblem problem, String packageName) throws IOException {
        this.packageName = packageName;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Domain-File");
        chooser.showOpenDialog(null);
        File domainFile = chooser.getSelectedFile();
        this.printDomain(domainFile);
        chooser.setDialogTitle("Problem-File");
        chooser.showOpenDialog(null);
        File problemFile = chooser.getSelectedFile();
        this.printProblem(problem, problemFile);
    }
}

