/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.algorithms.strips.forward;

import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.core.Action;
import java.util.Collection;

public class StripsForwardPlanningNode {
    private final Monom add;
    private final Monom del;
    private final Action actionToReachState;

    public StripsForwardPlanningNode(Monom add, Monom del, Action actionToReachState) {
        if (add == null) {
            throw new IllegalArgumentException("Add list must not be NULL");
        }
        if (del == null) {
            throw new IllegalArgumentException("Del list must not be NULL");
        }
        this.add = add;
        this.del = del;
        this.actionToReachState = actionToReachState;
    }

    public Monom getAdd() {
        return this.add;
    }

    public Monom getDel() {
        return this.del;
    }

    public Monom getStateRelativeToInitState(Monom initState) {
        Monom state = new Monom((Collection)initState);
        state.removeAll((Collection)this.del);
        state.addAll((Collection)this.add);
        return state;
    }

    public Action getActionToReachState() {
        return this.actionToReachState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.add == null ? 0 : this.add.hashCode());
        result = 31 * result + (this.del == null ? 0 : this.del.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StripsForwardPlanningNode other = (StripsForwardPlanningNode)obj;
        if (this.add == null ? other.add != null : !this.add.equals((Object)other.add)) {
            return false;
        }
        return !(this.del == null ? other.del != null : !this.del.equals((Object)other.del));
    }

    public String toString() {
        return "StripsForwardPlanningNode [addSize=" + this.add.size() + ", delSize=" + this.del.size() + ", actionToReachState=" + (this.actionToReachState != null ? this.actionToReachState.getEncoding() : null) + "]";
    }
}

