/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.core;

import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Plan
implements IPlan {
    private final List<Action> actions;
    private final Map<String, Object> annotations;

    public Plan(List<Action> actions) {
        this(actions, new HashMap<String, Object>());
    }

    public Plan(List<Action> actions, Map<String, Object> annotations) {
        this.actions = actions;
        this.annotations = annotations;
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    public void setAnnotation(String key, Object value) {
        this.annotations.put(key, value);
    }

    public void setAnnotation(Map<String, Object> annotations) {
        annotations.putAll(annotations);
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public Monom getStateAfterApplicationGivenInitState(Monom initState) {
        Monom newState = new Monom((Collection)initState);
        for (Action action : this.actions) {
            StripsUtil.updateState(newState, action);
        }
        return newState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plan other = (Plan)obj;
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }
}

