/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.classical.problems.strips.Operation;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.TaskPlannerUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.core.interfaces.PathUnifyingGraphGenerator;
import ai.libs.jaicore.search.model.travesaltree.NodeExpansionDescription;
import ai.libs.jaicore.search.model.travesaltree.NodeType;
import ai.libs.jaicore.search.structure.graphgenerator.NodeGoalTester;
import ai.libs.jaicore.search.structure.graphgenerator.SingleRootGenerator;
import ai.libs.jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFDGraphGenerator
implements GraphGenerator<TFDNode, String>,
PathUnifyingGraphGenerator<TFDNode, String> {
    private static Logger logger = LoggerFactory.getLogger(TFDGraphGenerator.class);
    protected TaskPlannerUtil util = new TaskPlannerUtil(null);
    protected final IHTNPlanningProblem problem;
    protected final Map<String, Operation> primitiveTasks = new HashMap<String, Operation>();

    public TFDGraphGenerator(IHTNPlanningProblem problem) {
        this.problem = problem;
        for (Operation operation : problem.getDomain().getOperations()) {
            this.primitiveTasks.put(operation.getName(), operation);
        }
    }

    protected Collection<TFDNode> getSuccessorsResultingFromResolvingPrimitiveTask(Monom state, Literal taskToBeResolved, List<Literal> remainingOtherTasks) throws InterruptedException {
        ArrayList<TFDNode> successors = new ArrayList<TFDNode>();
        for (Action applicableAction : this.util.getActionsForPrimitiveTaskThatAreApplicableInState(null, this.primitiveTasks.get(taskToBeResolved.getPropertyName()), taskToBeResolved, state)) {
            Monom stateCopy = new Monom((Collection)state);
            StripsUtil.updateState(stateCopy, applicableAction);
            successors.add(this.postProcessPrimitiveTaskNode(new TFDNode(stateCopy, remainingOtherTasks, null, applicableAction)));
        }
        return successors;
    }

    protected Collection<TFDNode> getSuccessorsResultingFromResolvingComplexTask(Monom state, Literal taskToBeResolved, List<Literal> remainingOtherTasks) throws InterruptedException {
        ArrayList<TFDNode> successors = new ArrayList<TFDNode>();
        Collection<MethodInstance> applicableMethodInstances = this.util.getMethodInstancesForTaskThatAreApplicableInState(null, this.problem.getDomain().getMethods(), taskToBeResolved, state, remainingOtherTasks);
        assert (this.areLonelyMethodsContainedAtMostOnce(applicableMethodInstances));
        for (MethodInstance instance : applicableMethodInstances) {
            List<Literal> remainingTasks = this.stripTNPrefixes(this.util.getTaskChainOfTotallyOrderedNetwork(instance.getNetwork()));
            remainingTasks.addAll(remainingOtherTasks);
            successors.add(this.postProcessComplexTaskNode(new TFDNode(state, remainingTasks, instance, null)));
        }
        return successors;
    }

    private boolean areLonelyMethodsContainedAtMostOnce(Collection<MethodInstance> instances) {
        ArrayList<Method> usedMethods = new ArrayList<Method>();
        for (MethodInstance mi : instances) {
            if (!mi.getMethod().isLonely()) continue;
            boolean doubleUseDetected = usedMethods.contains(mi.getMethod());
            assert (!doubleUseDetected) : "Lonely method " + mi.getMethod() + " has been generated several times as being applicable!";
            usedMethods.add(mi.getMethod());
        }
        return true;
    }

    protected List<Literal> stripTNPrefixes(List<Literal> taskList) {
        return taskList.stream().map(l -> {
            String taskName = l.getPropertyName().substring(l.getPropertyName().indexOf(45) + 1, l.getPropertyName().length());
            return new Literal(taskName, l.getParameters(), l.isPositive());
        }).collect(Collectors.toList());
    }

    protected TFDNode postProcessPrimitiveTaskNode(TFDNode node) {
        return node;
    }

    protected TFDNode postProcessComplexTaskNode(TFDNode node) {
        return node;
    }

    public SingleRootGenerator<TFDNode> getRootGenerator() {
        return () -> new TFDNode(this.problem.getInit(), this.stripTNPrefixes(new TaskPlannerUtil(null).getTaskChainOfTotallyOrderedNetwork(this.problem.getNetwork())));
    }

    public SuccessorGenerator<TFDNode, String> getSuccessorGenerator() {
        return l -> {
            Monom state = l.getState();
            ArrayList<Literal> currentlyRemainingTasks = new ArrayList<Literal>(l.getRemainingTasks());
            if (currentlyRemainingTasks.isEmpty()) {
                return new ArrayList();
            }
            Literal nextTaskTmp = (Literal)currentlyRemainingTasks.get(0);
            currentlyRemainingTasks.remove(0);
            String nextTaskName = nextTaskTmp.getPropertyName();
            Literal nextTask = new Literal(nextTaskName, nextTaskTmp.getParameters());
            long creationStartTime = System.currentTimeMillis();
            Collection<Object> successors = this.primitiveTasks.containsKey(nextTask.getPropertyName()) ? this.getSuccessorsResultingFromResolvingPrimitiveTask(state, nextTask, currentlyRemainingTasks) : this.getSuccessorsResultingFromResolvingComplexTask(state, nextTask, currentlyRemainingTasks);
            logger.info("Node generation finished and took {}ms", (Object)(System.currentTimeMillis() - creationStartTime));
            successors = successors.stream().map(this::orderRemainingTasksByPriority).collect(Collectors.toList());
            return successors.stream().map(n -> new NodeExpansionDescription(n, (Object)(n.getAppliedAction() != null ? n.getAppliedAction().getEncoding() : n.getAppliedMethodInstance().getEncoding()), NodeType.OR)).collect(Collectors.toList());
        };
    }

    public TFDNode orderRemainingTasksByPriority(TFDNode node) {
        Pattern p = Pattern.compile("(\\d+)_");
        ArrayList unorderedLiterals = new ArrayList();
        HashMap orderedLiterals = new HashMap();
        node.getRemainingTasks().forEach(t -> {
            Matcher m = p.matcher(t.getPropertyName());
            if (m.find()) {
                int order = Integer.parseInt(m.group(1));
                if (!orderedLiterals.containsKey(order)) {
                    orderedLiterals.put(order, new ArrayList());
                }
                List tasksWithorder = (List)orderedLiterals.get(order);
                tasksWithorder.add(t);
            } else {
                unorderedLiterals.add(t);
            }
        });
        ArrayList<Literal> newLiteralList = new ArrayList<Literal>();
        orderedLiterals.keySet().stream().sorted().forEach(order -> newLiteralList.addAll((Collection)orderedLiterals.get(order)));
        newLiteralList.addAll(unorderedLiterals);
        return new TFDNode(node.getState(), newLiteralList, node.getAppliedMethodInstance(), node.getAppliedAction());
    }

    public NodeGoalTester<TFDNode> getGoalTester() {
        return l -> l.getRemainingTasks().isEmpty();
    }

    public boolean isPathSemanticallySubsumed(List<TFDNode> path, List<TFDNode> potentialSuperPath) throws InterruptedException {
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            if (path.get(i).equals(potentialSuperPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("util", this.util);
        fields.put("problem", this.problem);
        fields.put("primitiveTasks", this.primitiveTasks);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

