/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.theories.EvaluablePredicate;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.TaskPlannerUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDRestProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFDNodeUtil {
    private static Map<List<TFDNode>, Integer> cache = new HashMap<List<TFDNode>, Integer>();
    private Logger logger = LoggerFactory.getLogger(TFDNodeUtil.class);
    private final TaskPlannerUtil util;
    private boolean checkArguments = true;

    public TFDNodeUtil(Map<String, EvaluablePredicate> evaluablePlanningPredicates) {
        this.util = new TaskPlannerUtil(evaluablePlanningPredicates);
    }

    private boolean checkDoubleRestProblemComputationOccurrence(List<TFDNode> path) {
        if (cache.containsKey(path)) {
            this.logger.info("already seen path {} times", (Object)cache.get(path));
            return false;
        }
        cache.put(path, 0);
        return true;
    }

    public List<TFDNode> getPathOfNode(TFDNode node, Map<TFDNode, TFDNode> parentMap) {
        ArrayList<TFDNode> path = new ArrayList<TFDNode>();
        TFDNode current = node;
        while (current != null) {
            assert (!path.contains(current)) : "There is a loop in the path! Node " + node + " has been visited twice!\n\tThe full path is: \n\t\t" + StringUtil.implode((Collection)SetUtil.getInvertedCopyOfList((List)SetUtil.addAndGet(path, (Object)current)).stream().map(n -> n.toString()).collect(Collectors.toList()), (String)"\n\t\t");
            path.add(current);
            current = parentMap.get(current);
        }
        Collections.reverse(path);
        return path;
    }

    public TFDRestProblem getRestProblem(List<TFDNode> path) {
        if (this.checkArguments && !this.checkDoubleRestProblemComputationOccurrence(path)) {
            throw new IllegalArgumentException("We must not generate the information of a node twice!");
        }
        TFDNode latest = null;
        for (TFDNode n : path) {
            if (n.getProblem() == null) continue;
            latest = n;
        }
        Iterator<TFDNode> i = path.iterator();
        TFDNode init = null;
        do {
            TFDNode n;
            if ((n = i.next()) != latest) continue;
            init = n;
        } while (init == null);
        Monom state = new Monom((Collection)init.getState(), false);
        ArrayList<Literal> remainingTasks = new ArrayList<Literal>(init.getRemainingTasks());
        while (i.hasNext()) {
            TFDNode n = i.next();
            Action appliedAction = n.getAppliedAction();
            if (appliedAction != null) {
                StripsUtil.updateState(state, appliedAction);
            }
            remainingTasks.remove(0);
            MethodInstance appliedMethodInstance = n.getAppliedMethodInstance();
            if (appliedMethodInstance == null) continue;
            int j = 0;
            for (Literal remainingTask : this.util.getTaskChainOfTotallyOrderedNetwork(appliedMethodInstance.getNetwork())) {
                remainingTasks.add(j++, remainingTask);
            }
        }
        return new TFDRestProblem(state, new ArrayList<Literal>(remainingTasks));
    }

    public Monom getState(List<TFDNode> path) {
        return this.getRestProblem(path).getState();
    }

    private boolean checkConsistency(Monom state, Map<CNFFormula, Monom> addLists) {
        for (Literal lit : state) {
            if (!lit.getPropertyName().equals("cluster")) continue;
            String clusterName = ((ConstantParam)lit.getConstantParams().get(0)).getName();
            boolean foundSmallest = false;
            boolean foundRepresentant = false;
            for (Literal lit2 : state) {
                if (lit2.getPropertyName().equals("smallest") && ((ConstantParam)lit2.getConstantParams().get(1)).getName().equals(clusterName)) {
                    foundSmallest = true;
                    String smallestItem = ((ConstantParam)lit2.getConstantParams().get(0)).getName();
                    ArrayList<ConstantParam> params = new ArrayList<ConstantParam>();
                    params.add(new ConstantParam(smallestItem));
                    params.add(new ConstantParam(clusterName));
                    Literal lit3 = new Literal("in", params);
                    if (!state.contains((Object)lit3)) {
                        throw new IllegalStateException("Smallest item in cluster " + clusterName + " is " + smallestItem + ", which is not even contained according to state " + state + "!");
                    }
                    for (Literal lit4 : state) {
                        if (!lit4.getPropertyName().equals("in") || !((ConstantParam)lit4.getConstantParams().get(1)).getName().equals(clusterName) || !state.contains((Object)new Literal("bigger('" + smallestItem + "','" + ((ConstantParam)lit4.getConstantParams().get(0)).getName() + "')"))) continue;
                        throw new IllegalStateException("Cluster " + clusterName + " has " + smallestItem + " as smallest item, but " + ((ConstantParam)lit4.getConstantParams().get(0)).getName() + " is smaller");
                    }
                    break;
                }
                if (!lit2.getPropertyName().equals("represents") || !((ConstantParam)lit2.getConstantParams().get(1)).getName().equals(clusterName)) continue;
                foundRepresentant = true;
                break;
            }
            if (foundSmallest || foundRepresentant) continue;
            throw new IllegalStateException("State " + state + " does not specify a smallest element for cluster " + clusterName + " after applying addList " + addLists);
        }
        return true;
    }

    public List<Literal> getRemainingTasks(List<TFDNode> path) {
        return this.getRestProblem(path).getRemainingTasks();
    }
}

