/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.classical.algorithms.strips.forward;

import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsForwardPlanningNode;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.classical.problems.strips.StripsAction;
import ai.libs.jaicore.planning.classical.problems.strips.StripsPlanningProblem;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripsForwardPlanningGraphGenerator
implements IGraphGenerator<StripsForwardPlanningNode, String> {
    private final StripsPlanningProblem problem;
    private static final Logger logger = LoggerFactory.getLogger(StripsForwardPlanningGraphGenerator.class);
    private final Monom initState;
    private final Set<StripsForwardPlanningNode> completelyExpandedNodes = new HashSet<StripsForwardPlanningNode>();

    public StripsForwardPlanningGraphGenerator(StripsPlanningProblem problem) {
        this.problem = problem;
        this.initState = problem.getInitState();
    }

    public ISingleRootGenerator<StripsForwardPlanningNode> getRootGenerator() {
        return () -> {
            StripsForwardPlanningNode root = new StripsForwardPlanningNode(new Monom(), new Monom(), null);
            return root;
        };
    }

    private List<StripsAction> getApplicableActionsInNode(StripsForwardPlanningNode node) {
        logger.info("Computing successors for node {}", (Object)node);
        long start = System.currentTimeMillis();
        Monom state = node.getStateRelativeToInitState(this.initState);
        List<StripsAction> applicableActions = StripsUtil.getApplicableActionsInState(state, this.problem.getDomain());
        logger.debug("Computation of applicable actions took {}ms", (Object)(System.currentTimeMillis() - start));
        return applicableActions;
    }

    public ISuccessorGenerator<StripsForwardPlanningNode, String> getSuccessorGenerator() {
        return new ISuccessorGenerator<StripsForwardPlanningNode, String>(){

            public List<INewNodeDescription<StripsForwardPlanningNode, String>> generateSuccessors(StripsForwardPlanningNode node) throws InterruptedException {
                if (StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.contains(node)) {
                    throw new IllegalArgumentException("Successors of node " + node + " have already been computed.");
                }
                long start = System.currentTimeMillis();
                ArrayList<INewNodeDescription<StripsForwardPlanningNode, String>> successors = new ArrayList<INewNodeDescription<StripsForwardPlanningNode, String>>();
                List applicableActions = StripsForwardPlanningGraphGenerator.this.getApplicableActionsInNode(node);
                for (StripsAction action : applicableActions) {
                    long t = System.currentTimeMillis();
                    Monom del = new Monom((Collection)node.getDel());
                    Monom add = new Monom((Collection)node.getAdd());
                    del.addAll((Collection)action.getDeleteList());
                    add.removeAll((Collection)action.getDeleteList());
                    add.addAll((Collection)action.getAddList());
                    StripsForwardPlanningNode newNode = new StripsForwardPlanningNode(add, del, action);
                    successors.add((INewNodeDescription<StripsForwardPlanningNode, String>)new NodeExpansionDescription((Object)newNode, (Object)"edge label"));
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Created the node expansion description within {}ms. New state size is {}.", (Object)(System.currentTimeMillis() - t), (Object)newNode.getStateRelativeToInitState(StripsForwardPlanningGraphGenerator.this.initState).size());
                }
                logger.info("Generated {} successors in {}ms.", (Object)successors.size(), (Object)(System.currentTimeMillis() - start));
                StripsForwardPlanningGraphGenerator.this.completelyExpandedNodes.add(node);
                return successors;
            }
        };
    }
}

