/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn;

import ai.libs.jaicore.graph.LabeledGraph;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCAction;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn.RTNEdge;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.rtn.RTNNode;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.stn.MethodInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RTNUtil {
    private RTNUtil() {
    }

    public static List<TFDNode> serializeGraph(LabeledGraph<RTNNode, RTNEdge> g) {
        RTNNode root = (RTNNode)g.getSources().iterator().next();
        return RTNUtil.serializeGraphUnderNode(g, root, new HashMap<ConstantParam, ConstantParam>(), null, null);
    }

    private static List<TFDNode> serializeGraphUnderNode(LabeledGraph<RTNNode, RTNEdge> g, RTNNode n, Map<ConstantParam, ConstantParam> context, MethodInstance nextAppliedMethodInstance, CEOCAction nextAppliedAction) {
        ArrayList<TFDNode> serialization = new ArrayList<TFDNode>();
        for (RTNNode np : g.getSuccessors((Object)n)) {
            HashMap<VariableParam, ConstantParam> grounding;
            Object l2;
            Map<ConstantParam, ConstantParam> mapExtension = ((RTNEdge)g.getEdgeLabel((Object)n, (Object)np)).getContextRecreator();
            HashMap<ConstantParam, ConstantParam> newContext = new HashMap<ConstantParam, ConstantParam>();
            newContext.putAll(context);
            if (mapExtension != null) {
                newContext.putAll(mapExtension);
            }
            Monom state = new Monom();
            for (Object l2 : n.getState()) {
                state.add((Object)new Literal((Literal)l2, newContext));
            }
            ArrayList<Literal> tasks = new ArrayList<Literal>();
            l2 = n.getRemainingTasks().iterator();
            while (l2.hasNext()) {
                Literal l3 = (Literal)l2.next();
                tasks.add(new Literal(l3, newContext));
            }
            RTNEdge edge = (RTNEdge)g.getEdgeLabel((Object)n, (Object)np);
            MethodInstance appliedMethodInstance = null;
            CEOCAction appliedAction = null;
            if (edge.getMethodInstance() != null) {
                grounding = new HashMap<VariableParam, ConstantParam>(edge.getMethodInstance().getGrounding());
                for (Map.Entry groundingEntry : grounding.entrySet()) {
                    if (!newContext.containsKey(groundingEntry.getValue())) continue;
                    grounding.put((VariableParam)groundingEntry.getKey(), (ConstantParam)newContext.get(groundingEntry.getValue()));
                }
                appliedMethodInstance = new MethodInstance(edge.getMethodInstance().getMethod(), grounding);
            }
            if (edge.getAppliedAction() != null) {
                grounding = new HashMap<VariableParam, ConstantParam>(edge.getAppliedAction().getGrounding());
                for (Map.Entry groundingEntry : grounding.entrySet()) {
                    if (!newContext.containsKey(groundingEntry.getValue())) continue;
                    grounding.put((VariableParam)groundingEntry.getKey(), (ConstantParam)newContext.get(groundingEntry.getValue()));
                }
                appliedAction = new CEOCAction(edge.getAppliedAction().getOperation(), grounding);
            }
            serialization.add(new TFDNode(state, tasks, nextAppliedMethodInstance, nextAppliedAction));
            serialization.addAll(RTNUtil.serializeGraphUnderNode(g, np, newContext, appliedMethodInstance, appliedAction));
        }
        return serialization;
    }

    public static Collection<String> getClassesThatRemainToBeSeparated(RTNNode node) {
        if (!RTNUtil.getClustersThatWillBeRefined(node).isEmpty()) {
            return RTNUtil.getClassesThatAreNotIsolated(node);
        }
        return node.getRemainingTasks().stream().filter(l -> l.getPropertyName().contains("declareClusterRepresentant")).map(l -> ((ConstantParam)l.getConstantParams().get(1)).getName()).collect(Collectors.toList());
    }

    public static Collection<String> getClassesThatAreInAnyCluster(RTNNode node) {
        return RTNUtil.getClassesThatExistInState(node).stream().filter(c -> node.getState().stream().anyMatch(l -> l.getPropertyName().equals("in") && ((ConstantParam)l.getConstantParams().get(0)).getName().equals(c))).collect(Collectors.toList());
    }

    public static Collection<String> getClassesThatAreInAClusterThatNeedsToBeRefined(RTNNode node) {
        Collection<String> clustersToBeRefined = RTNUtil.getClustersThatWillBeRefined(node);
        HashSet<String> remainingClasses = new HashSet<String>();
        for (Literal l : node.getState()) {
            if (!l.getPropertyName().equals("in") || !clustersToBeRefined.contains(((ConstantParam)l.getConstantParams().get(1)).getName())) continue;
            remainingClasses.add(((ConstantParam)l.getConstantParams().get(0)).getName());
        }
        return remainingClasses;
    }

    public static Collection<String> getClassesThatAreNotIsolated(RTNNode node) {
        return RTNUtil.getClassesThatAreInAnyCluster(node).stream().filter(c -> node.getState().stream().noneMatch(l -> l.getPropertyName().equals("represents") && ((ConstantParam)l.getConstantParams().get(0)).getName().equals(c))).collect(Collectors.toList());
    }

    public static Collection<String> getClassesThatAreIsolated(RTNNode node) {
        return RTNUtil.getClassesThatAreInAnyCluster(node).stream().filter(c -> node.getState().stream().anyMatch(l -> l.getPropertyName().equals("represents") && ((ConstantParam)l.getConstantParams().get(0)).getName().equals(c))).collect(Collectors.toList());
    }

    public static Collection<String> getClassesThatExistInState(RTNNode node) {
        return node.getState().stream().filter(l -> l.getPropertyName().equals("in")).map(l -> ((ConstantParam)l.getConstantParams().get(0)).getName()).collect(Collectors.toList());
    }

    public static Collection<String> getClustersThatExistInState(RTNNode node) {
        return node.getState().stream().filter(l -> l.getPropertyName().equals("in")).map(l -> ((ConstantParam)l.getConstantParams().get(1)).getName()).collect(Collectors.toList());
    }

    public static Collection<String> getClustersThatWillBeRefined(RTNNode node) {
        ArrayList<String> clusters = new ArrayList<String>();
        for (Literal l : node.getRemainingTasks()) {
            if (!l.getPropertyName().contains("refine")) continue;
            clusters.add(((ConstantParam)l.getConstantParams().get(0)).getName());
        }
        return clusters;
    }
}

