/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.converters;

import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.AShop2Converter;
import ai.libs.jaicore.planning.hierarchical.problems.stn.Method;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class CEOCIPSTN2JSHOP2
extends AShop2Converter {
    public void printDomain(Writer writer, String name) throws IOException {
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write("(defdomain " + name + "\n " + this.indent(1) + " (\n");
        bw.flush();
        bw.write(this.indent(1) + ")\n");
        bw.write(")");
        bw.flush();
    }

    public void printOperation(BufferedWriter bw, CEOCOperation operation, int i) throws IOException {
        Monom addList;
        bw.write(this.indent(i) + "(:operator (!" + this.maskString(operation.getName()));
        for (LiteralParam literalParam : operation.getParams()) {
            bw.write(" ?" + literalParam.getName());
            bw.flush();
        }
        bw.write(")\n ");
        this.printMonom(bw, operation.getPrecondition(), i + 1);
        Map<CNFFormula, Monom> deleteLists = operation.getDeleteLists();
        boolean bl = deleteLists.containsKey(new CNFFormula());
        if (deleteLists.size() > 1 || deleteLists.size() == 1 && !bl) {
            throw new IllegalArgumentException("The operation " + operation.getName() + " contains conditional deletes, which cannot be converted to JSHOP2 format.");
        }
        Monom deleteList = bl ? deleteLists.get(new CNFFormula()) : new Monom();
        this.printMonom(bw, deleteList, i + 1);
        Map<CNFFormula, Monom> addLists = operation.getAddLists();
        boolean containsUnconditionalAdd = deleteLists.containsKey(new CNFFormula());
        Monom monom = addList = containsUnconditionalAdd ? addLists.get(new CNFFormula()) : new Monom();
        if (addLists.size() > 1 || addLists.size() == 1 && !containsUnconditionalAdd) {
            throw new IllegalArgumentException("The operation " + operation.getName() + " contains conditional adds, which cannot be converted to JSHOP2 format.");
        }
        this.printMonom(bw, addList, i + 1);
        bw.write(this.indent(i) + ")\n\n");
        bw.flush();
    }

    @Override
    public void printLiteral(BufferedWriter bw, Literal lit) throws IOException {
        bw.write(" (");
        boolean negated = lit.isNegated();
        if (negated) {
            bw.write("not(");
        }
        bw.write(this.maskString(lit.getPropertyName()));
        for (LiteralParam param : lit.getParameters()) {
            bw.write(" ?" + this.maskString(param.getName()));
        }
        if (negated) {
            bw.write(")");
        }
        bw.write(")");
        bw.flush();
    }

    public void printMethod(BufferedWriter bw, Method method, int i) throws IOException {
        bw.write(this.indent(i) + "(:method");
        this.printLiteral(bw, method.getTask());
        bw.write("\n");
        bw.write(this.indent(i + 1) + method.getName());
        bw.write("\n");
        this.printMonom(bw, method.getPrecondition(), i + 1);
        this.printNetwork(bw, method.getNetwork(), i + 1);
        bw.write(this.indent(i) + ")\n");
        bw.flush();
    }

    private void printNetwork(BufferedWriter bw, TaskNetwork network, int i) throws IOException {
        bw.write(this.indent(i) + "(");
        Literal next = (Literal)network.getRoot();
        while (next != null) {
            this.printLiteral(bw, next);
            Iterator it = network.getSuccessors(next).iterator();
            next = it.hasNext() ? (Literal)it.next() : null;
        }
        bw.write(")\n");
    }

    public void printProblem(CEOCIPSTNPlanningProblem problem, Writer writer, String name) throws IOException {
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write("(defproblem problem " + name + "\n");
        bw.write(this.indent(1) + "(\n");
        this.printMonom(bw, problem.getInit(), 2, true);
        bw.write(this.indent(1) + ")\n");
        bw.write(this.indent(1) + "(\n");
        this.printNetwork(bw, problem.getNetwork(), 2);
        bw.write(this.indent(1) + ")\n");
        bw.write(")");
        bw.flush();
    }

    public String maskString(String str) {
        str = str.replaceAll("\\.", "_");
        str = str.replaceAll(":", "__");
        str = str.replaceAll("<", "___");
        str = str.replaceAll(">", "___");
        str = str.replaceAll("\\[\\]", "Array");
        return str;
    }
}

