/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.htn;

import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.planning.core.EvaluatedPlan;
import ai.libs.jaicore.planning.core.interfaces.IEvaluatedPlan;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHierarchicalPlanningToGraphSearchReduction;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostSensitivePlanningToSearchProblemReduction<N, A, V extends Comparable<V>, I1 extends IHTNPlanningProblem, I2 extends GraphSearchWithPathEvaluationsInput<N, A, V>, O2 extends IEvaluatedPath<N, A, V>>
implements IHierarchicalPlanningToGraphSearchReduction<N, A, CostSensitiveHTNPlanningProblem<I1, V>, IEvaluatedPlan<V>, I2, O2> {
    private final IHierarchicalPlanningToGraphSearchReduction<N, A, I1, IPlan, GraphSearchInput<N, A>, ILabeledPath<N, A>> baseReduction;
    private final AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, I2, O2> forwardReduction;

    public CostSensitivePlanningToSearchProblemReduction(IHierarchicalPlanningToGraphSearchReduction<N, A, I1, IPlan, GraphSearchInput<N, A>, ILabeledPath<N, A>> baseReduction, AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, I2, O2> forwardReduction) {
        this.baseReduction = baseReduction;
        this.forwardReduction = forwardReduction;
    }

    public I2 encodeProblem(CostSensitiveHTNPlanningProblem<I1, V> problem) {
        return (I2)((GraphSearchWithPathEvaluationsInput)this.forwardReduction.encodeProblem((Object)new GraphSearchWithPathEvaluationsInput((IPathSearchInput)this.baseReduction.encodeProblem(problem.getCorePlanningProblem()), new Evaluator<N, A, V>(problem.getPlanEvaluator(), this.baseReduction))));
    }

    public IEvaluatedPlan<V> decodeSolution(O2 solution) {
        return new EvaluatedPlan<Comparable>((IPlan)this.baseReduction.decodeSolution(solution), solution.getScore());
    }

    private static class Evaluator<N, A, V extends Comparable<V>>
    implements IObjectEvaluator<ILabeledPath<N, A>, V>,
    ILoggingCustomizable {
        private Logger logger = LoggerFactory.getLogger(Evaluator.class);
        private final IObjectEvaluator<IPlan, V> planEvaluator;
        private final IHierarchicalPlanningToGraphSearchReduction<N, A, ?, IPlan, GraphSearchInput<N, A>, ILabeledPath<N, A>> baseReduction;

        public Evaluator(IObjectEvaluator<IPlan, V> planEvaluator, IHierarchicalPlanningToGraphSearchReduction<N, A, ?, IPlan, GraphSearchInput<N, A>, ILabeledPath<N, A>> baseReduction) {
            this.planEvaluator = planEvaluator;
            this.baseReduction = baseReduction;
        }

        public String getLoggerName() {
            return this.logger.getName();
        }

        public void setLoggerName(String name) {
            this.logger = LoggerFactory.getLogger((String)name);
            if (this.planEvaluator instanceof ILoggingCustomizable) {
                ((ILoggingCustomizable)this.planEvaluator).setLoggerName(name + ".pe");
                this.logger.info("Setting logger of plan evaluator {} to {}.pe", (Object)this.planEvaluator.getClass().getName(), (Object)name);
            } else {
                this.logger.info("Plan evaluator {} is not configurable for logging, so not configuring it.", this.planEvaluator);
            }
        }

        public V evaluate(ILabeledPath<N, A> solutionPath) throws InterruptedException, ObjectEvaluationFailedException {
            this.logger.info("Forwarding evaluation to plan evaluator {}", (Object)this.planEvaluator.getClass().getName());
            return (V)this.planEvaluator.evaluate((Object)((IPlan)this.baseReduction.decodeSolution(solutionPath)));
        }
    }
}

