/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.planning.hierarchical.problems.stn;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import java.io.Serializable;
import java.util.List;

public class Method
implements Serializable {
    private static final long serialVersionUID = 704153871624796863L;
    private final String name;
    private final List<VariableParam> parameters;
    private final Literal task;
    private final Monom precondition;
    private final TaskNetwork network;
    private final boolean lonely;

    public Method(String name, List<VariableParam> parameters, Literal task, Monom precondition, TaskNetwork network, boolean lonely) {
        this.name = name;
        this.parameters = parameters;
        this.task = task;
        this.precondition = precondition;
        this.network = network;
        this.lonely = lonely;
        if (!this.doAllParamsInNetworkOccurInParameterList()) {
            throw new IllegalArgumentException("Invalid method instantiation for " + name + ". There are parameters in the task network that do not occur in the parameter list.");
        }
    }

    private boolean doAllParamsInNetworkOccurInParameterList() {
        for (Literal l : this.network.getItems()) {
            if (SetUtil.difference((List)l.getVariableParams(), this.parameters).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public List<VariableParam> getParameters() {
        return this.parameters;
    }

    public Literal getTask() {
        return this.task;
    }

    public Monom getPrecondition() {
        return this.precondition;
    }

    public TaskNetwork getNetwork() {
        return this.network;
    }

    public boolean isLonely() {
        return this.lonely;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.precondition == null ? 0 : this.precondition.hashCode());
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals((Object)other.network)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.precondition == null ? other.precondition != null : !this.precondition.equals((Object)other.precondition)) {
            return false;
        }
        return !(this.task == null ? other.task != null : !this.task.equals((Object)other.task));
    }

    public String toString() {
        return "Method [name=" + this.name + ", parameters=" + this.parameters + ", task=" + this.task + ", precondition=" + this.precondition + ", network=" + (Object)((Object)this.network) + ", lonely=" + this.lonely + "]";
    }
}

