/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.processes;

import ai.libs.jaicore.processes.ProcessInfo;
import ai.libs.jaicore.processes.ProcessUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcessList
extends ArrayList<ProcessInfo> {
    private final long timestamp = System.currentTimeMillis();
    private final List<Integer> fieldSeparationIndices = new ArrayList<Integer>();

    public static void main(String[] args) throws IOException {
        new ProcessList().stream().forEach((? super T p) -> System.out.println(p));
    }

    public ProcessList() throws IOException {
        Process p = ProcessUtil.getProcessListProcess();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            boolean tableInitialized = false;
            int lineNumber = 0;
            while ((line = input.readLine()) != null) {
                switch (ProcessUtil.getOS()) {
                    case WIN: {
                        int i;
                        if (!tableInitialized) {
                            if (!line.startsWith("===")) break;
                            int offset = 0;
                            String[] headerLineParts = line.split(" ");
                            for (i = 0; i < headerLineParts.length; ++i) {
                                this.fieldSeparationIndices.add(offset += headerLineParts[i].length());
                                ++offset;
                            }
                            tableInitialized = true;
                            break;
                        }
                        ArrayList<String> entries = new ArrayList<String>();
                        int indexFrom = 0;
                        int indexTo = 0;
                        for (int i2 = 0; i2 < this.fieldSeparationIndices.size(); ++i2) {
                            indexTo = this.fieldSeparationIndices.get(i2);
                            entries.add(line.substring(indexFrom, indexTo).trim());
                            indexFrom = indexTo + 1;
                        }
                        entries.add(line.substring(indexTo).trim());
                        this.add(new ProcessInfo(Integer.parseInt((String)entries.get(1)), (String)entries.get(0), (String)entries.get(4)));
                        break;
                    }
                    case LINUX: {
                        int i;
                        if (lineNumber <= 0) break;
                        String remainingLine = line;
                        ArrayList<String> entries = new ArrayList<String>();
                        for (i = 0; i < 6; ++i) {
                            int indexOfNextSpace = remainingLine.indexOf(" ");
                            if (indexOfNextSpace >= 0) {
                                entries.add(remainingLine.substring(0, indexOfNextSpace));
                                remainingLine = remainingLine.substring(indexOfNextSpace).trim();
                                continue;
                            }
                            entries.add(remainingLine);
                        }
                        this.add(new ProcessInfo(Integer.parseInt((String)entries.get(1)), (String)entries.get(5), (String)entries.get(4)));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Cannot create process list for OS " + (Object)((Object)ProcessUtil.getOS()));
                    }
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

