/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.processes;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.processes.CommandExecutionException;
import ai.libs.jaicore.processes.ProcessIDNotRetrievableException;
import ai.libs.jaicore.processes.ProcessUtil;
import ai.libs.jaicore.timing.TimedComputation;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMethodToProcessWrapper {
    private static final Random random = new Random(System.currentTimeMillis());
    private static final Logger logger = LoggerFactory.getLogger(JavaMethodToProcessWrapper.class);
    private static final List<JavaMethodToProcessWrapper> wrappers = new ArrayList<JavaMethodToProcessWrapper>();
    private String memory = "256M";
    private File tmpDir = new File("tmp");
    private int pidOfSubProcess;

    public static List<JavaMethodToProcessWrapper> getWrappers() {
        return wrappers;
    }

    public JavaMethodToProcessWrapper() {
        wrappers.add(this);
    }

    public static String getAbsoluteClasspath() {
        try {
            return System.getProperty("java.class.path") + File.pathSeparatorChar + URLDecoder.decode(JavaMethodToProcessWrapper.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("The encoding of the URL is unsupported", (Throwable)e);
            return null;
        }
    }

    public Object run(String clazz, String method, Object target, Object ... inputs) throws IOException, InterruptedException, InvocationTargetException, ProcessIDNotRetrievableException {
        return this.run(clazz, method, target, Arrays.asList(inputs));
    }

    public Optional<Object> runWithTimeout(String clazz, String method, Object target, int timeout, Object ... inputs) throws AlgorithmTimeoutedException, InvocationTargetException, InterruptedException {
        Object c;
        try {
            c = TimedComputation.compute(() -> this.run(clazz, method, target, inputs), (long)timeout, (String)"Process has timed out!");
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e.getCause());
        }
        if (Thread.interrupted()) {
            throw new IllegalStateException("We got interrupted but no InterruptedException was thrown!");
        }
        return c != null ? Optional.of(c) : Optional.empty();
    }

    public Object run(String clazz, String method, Object target, List<Object> inputs) throws IOException, InterruptedException, InvocationTargetException, ProcessIDNotRetrievableException {
        String id = String.valueOf(random.nextLong());
        File dir = new File(this.tmpDir.getAbsolutePath() + File.separator + id);
        dir.mkdirs();
        logger.info("Created tmp dir \"{}\" for invocation {}.{}({}).", new Object[]{dir.getAbsolutePath(), target, method, inputs});
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("java");
        commands.add("-cp");
        commands.add(JavaMethodToProcessWrapper.getAbsoluteClasspath());
        commands.add("-Xmx" + this.memory);
        commands.add(this.getClass().getName());
        commands.add(dir.getAbsolutePath());
        commands.add(clazz);
        commands.add(method);
        logger.info("Serializing object ...");
        String targetVal = "null";
        if (target != null) {
            targetVal = target.getClass().getName() + ".ser";
            FileUtil.serializeObject((Object)target, (String)(dir.getAbsolutePath() + File.separator + targetVal));
        }
        commands.add(targetVal);
        for (int i = 0; i < inputs.size(); ++i) {
            String argval;
            Object input = inputs.get(i);
            if (inputs.get(i) != null) {
                argval = input.getClass().getName() + ".ser";
                FileUtil.serializeObject((Object)inputs.get(i), (String)(dir.getAbsolutePath() + File.separator + argval));
            } else {
                argval = "null";
            }
            commands.add(argval);
        }
        logger.info("ProcessBuilder started");
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = pb.start();
        this.pidOfSubProcess = ProcessUtil.getPID(process);
        logger.info("Spawned process {}. Currently active java processes:", (Object)this.pidOfSubProcess);
        ProcessUtil.getRunningJavaProcesses().stream().forEach(p -> logger.info("\t{}", p));
        Thread killerHook = new Thread(() -> {
            logger.info("Destroying subprocess {}", (Object)this.pidOfSubProcess);
            if (process.isAlive()) {
                try {
                    process.destroy();
                    ProcessUtil.killProcess(this.pidOfSubProcess);
                }
                catch (IOException e) {
                    logger.error("An unexpected exception occurred while killing the process with id {}", (Object)this.pidOfSubProcess, (Object)e);
                }
            }
            logger.info("Subprocess {} destroyed.", (Object)this.pidOfSubProcess);
        });
        Runtime.getRuntime().addShutdownHook(killerHook);
        try {
            logger.info("Awaiting termination.");
            process.waitFor();
        }
        catch (InterruptedException e) {
            logger.info("Received interrupt");
            killerHook.start();
            FileUtil.deleteFolderRecursively((File)dir);
            throw e;
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(killerHook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        logger.info("Processing results ...");
        File serializedResult = new File(dir + File.separator + "result.ser");
        File nullResult = new File(dir + File.separator + "result.null");
        File exceptionResult = new File(dir + File.separator + "result.exception");
        if (serializedResult.exists()) {
            try {
                Object out = FileUtil.unserializeObject((String)serializedResult.getAbsolutePath());
                FileUtil.deleteFolderRecursively((File)dir);
                return out;
            }
            catch (ClassNotFoundException e) {
                logger.error("The class of the deserialized object could not be found", (Throwable)e);
            }
        }
        if (nullResult.exists()) {
            FileUtil.deleteFolderRecursively((File)dir);
            return null;
        }
        if (exceptionResult.exists()) {
            Exception exception = null;
            try {
                exception = (Exception)FileUtil.unserializeObject((String)exceptionResult.getAbsolutePath());
            }
            catch (ClassNotFoundException e) {
                logger.error("The class of the deserialized object could not be found", (Throwable)e);
            }
            FileUtil.deleteFolderRecursively((File)dir);
            throw new InvocationTargetException(exception);
        }
        logger.warn("Subprocess execution terminated but no result was observed for {}!", (Object)id);
        return null;
    }

    private static Object executeCommand(File folder, String clazz, String method_name, String target, LinkedList<String> argsArray) throws CommandExecutionException {
        try {
            logger.info("Invoking in folder {} method {} on class {}", new Object[]{folder, clazz, method_name});
            Object targetObject = null;
            if (!target.equals("null")) {
                targetObject = FileUtil.unserializeObject((String)(folder.getAbsolutePath() + File.separator + target));
            }
            Class[] params = new Class[argsArray.size()];
            Object[] objcts = new Object[argsArray.size()];
            int counter = 0;
            while (!argsArray.isEmpty()) {
                String descriptor = argsArray.poll();
                boolean isNull = descriptor.equals("");
                objcts[counter] = isNull ? null : FileUtil.unserializeObject((String)(folder.getAbsolutePath() + File.separator + descriptor));
                params[counter] = isNull ? null : Class.forName(descriptor.substring(0, descriptor.lastIndexOf(46)));
                ++counter;
            }
            Method method = MethodUtils.getMatchingAccessibleMethod(Class.forName(clazz), (String)method_name, (Class[])params);
            return method.invoke(targetObject, objcts);
        }
        catch (Exception e) {
            throw new CommandExecutionException(e);
        }
    }

    public static void main(String[] args) {
        LinkedList<String> argsArray = new LinkedList<String>(Arrays.asList(args));
        File folder = new File(argsArray.poll());
        if (!folder.exists()) {
            throw new IllegalArgumentException("The invocation call folder " + folder + " does not exist!");
        }
        String clazz = argsArray.poll();
        String methodName = argsArray.poll();
        String target = argsArray.poll();
        try {
            Object result = JavaMethodToProcessWrapper.executeCommand(folder, clazz, methodName, target, argsArray);
            FileUtil.serializeObject((Object)result, (String)(folder.getAbsolutePath() + File.separator + "result." + (result != null ? "ser" : "null")));
        }
        catch (Exception e) {
            logger.error("An exception occurred while serializing the object", (Throwable)e);
            try {
                FileUtil.serializeObject((Object)e, (String)(folder.getAbsolutePath() + File.separator + "result.exception"));
            }
            catch (IOException e1) {
                logger.error("An exception occurred while serializing the error message of the occurred exception.", (Throwable)e1);
            }
        }
        logger.info("Finishing subprocess");
    }

    public void setMemory(String pMemory) {
        this.memory = pMemory;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }
}

