/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.processes;

import ai.libs.jaicore.processes.Kernel32;
import ai.libs.jaicore.processes.OS;
import ai.libs.jaicore.processes.ProcessIDNotRetrievableException;
import ai.libs.jaicore.processes.ProcessInfo;
import ai.libs.jaicore.processes.ProcessList;
import ai.libs.jaicore.processes.W32API;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtil.class);

    private ProcessUtil() {
    }

    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") > -1) {
            return OS.WIN;
        }
        if (osName.indexOf("linux") > -1) {
            return OS.LINUX;
        }
        throw new UnsupportedOperationException("Cannot detect operating system " + osName);
    }

    public static Process getProcessListProcess() throws IOException {
        OS os = ProcessUtil.getOS();
        switch (os) {
            case WIN: {
                return Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
            }
            case LINUX: {
                return Runtime.getRuntime().exec("ps -e -o user,pid,ppid,c,size,cmd");
            }
        }
        throw new UnsupportedOperationException("No action defined for OS " + (Object)((Object)os));
    }

    public static Collection<ProcessInfo> getRunningJavaProcesses() throws IOException {
        return new ProcessList().stream().filter(pd -> pd.getDescr().startsWith("java")).collect(Collectors.toList());
    }

    public static int getPID(Process process) throws ProcessIDNotRetrievableException {
        try {
            if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                Integer pid = f.getInt(process);
                return pid;
            }
            if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                W32API.HANDLE handle = new W32API.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                Integer pid = kernel.getProcessId(handle);
                return pid;
            }
        }
        catch (Exception e) {
            throw new ProcessIDNotRetrievableException("Could not retrieve process ID", e);
        }
        throw new UnsupportedOperationException();
    }

    public static void killProcess(int pid) throws IOException {
        Runtime rt = Runtime.getRuntime();
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            rt.exec("taskkill /F /PID " + pid);
        } else {
            rt.exec("kill -9 " + pid);
        }
    }

    public static void killProcess(Process process) throws IOException {
        try {
            ProcessUtil.killProcess(ProcessUtil.getPID(process));
        }
        catch (ProcessIDNotRetrievableException e) {
            logger.warn("Cannot kill process with certainty. Thus try to kill the process via the process' destroy method.", (Throwable)e);
            process.destroyForcibly();
        }
    }
}

