/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.andor;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.graph.Graph;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.core.interfaces.IGraphSearch;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.model.travesaltree.NodeType;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndORBottomUpFilter<N, A, V extends Comparable<V>>
extends AAlgorithm<GraphSearchInput<N, A>, Graph<N>>
implements IGraphSearch<GraphSearchInput<N, A>, Graph<N>, N, A> {
    private Logger logger = LoggerFactory.getLogger(AndORBottomUpFilter.class);
    private String loggerName;
    private final Graph<InnerNodeLabel> graph = new Graph();
    private final IObjectEvaluator<Graph<N>, V> evaluator;
    private Graph<N> bestSolutionBase;
    private final int nodeLimit;

    public AndORBottomUpFilter(GraphGenerator<N, A> gg, IObjectEvaluator<Graph<N>, V> pEvaluator) {
        this(gg, pEvaluator, 1);
    }

    public AndORBottomUpFilter(GraphGenerator<N, A> gg, IObjectEvaluator<Graph<N>, V> pEvaluator, int andNodeLimit) {
        super(new GraphSearchInput<N, A>(gg));
        this.evaluator = pEvaluator;
        this.nodeLimit = andNodeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmEvent nextWithException() throws AlgorithmTimeoutedException, InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException {
        switch (this.getState()) {
            case created: {
                LinkedList<InnerNodeLabel> open = new LinkedList<InnerNodeLabel>();
                InnerNodeLabel root = new InnerNodeLabel(((SingleRootGenerator)((GraphSearchInput)this.getInput()).getGraphGenerator().getRootGenerator()).getRoot(), NodeType.AND);
                root.val = 0;
                open.add(root);
                this.post(new GraphInitializedEvent(this.getId(), root.node));
                this.graph.addItem((Object)root);
                while (!open.isEmpty()) {
                    InnerNodeLabel n = (InnerNodeLabel)open.poll();
                    try {
                        int generatedChildren = 0;
                        for (NodeExpansionDescription descr : ((GraphSearchInput)this.getInput()).getGraphGenerator().getSuccessorGenerator().generateSuccessors(n.node)) {
                            InnerNodeLabel newNode = new InnerNodeLabel(descr.getTo(), descr.getTypeOfToNode());
                            newNode.parent = n;
                            newNode.val = generatedChildren++;
                            Graph<InnerNodeLabel> graph = this.graph;
                            synchronized (graph) {
                                this.graph.addItem((Object)newNode);
                                this.logger.trace("Added {}-node {} as a child to {}", new Object[]{newNode.type, newNode, n});
                                this.graph.addEdge((Object)n, (Object)newNode);
                            }
                            open.add(newNode);
                            this.post(new NodeAddedEvent(this.getId(), n.node, newNode.node, descr.getTypeOfToNode() == NodeType.OR ? "or" : "and"));
                        }
                        this.logger.debug("Node expansion of {}-node {} completed. Generated {} successors.", new Object[]{n.type, n, generatedChildren});
                    }
                    catch (Exception e) {
                        throw new AlgorithmException((Throwable)e, "Received exception in algorithm initialization.");
                    }
                }
                this.logger.info("Size: {}", (Object)this.graph.getItems().size());
                return this.activate();
            }
            case active: {
                this.logger.debug("timeout: {}", (Object)this.getTimeout());
                try {
                    Queue<EvaluatedGraph> bestSolutions = this.filterNodeSolution((InnerNodeLabel)this.graph.getRoot());
                    this.logger.info("Number of solutions: {}", (Object)bestSolutions.size());
                    if (!bestSolutions.isEmpty()) {
                        this.bestSolutionBase = bestSolutions.poll().graph;
                    }
                    return this.terminate();
                }
                catch (ObjectEvaluationFailedException e) {
                    throw new AlgorithmException((Throwable)e, "Could not evaluate solution.");
                }
            }
        }
        throw new IllegalStateException("No handler defined for state " + this.getState());
    }

    private Queue<EvaluatedGraph> filterNodeSolution(InnerNodeLabel node) throws AlgorithmTimeoutedException, InterruptedException, ObjectEvaluationFailedException, AlgorithmExecutionCanceledException {
        AbstractCollection filteredSolutions = new PriorityQueue<EvaluatedGraph>((p1, p2) -> p2.value.compareTo(p1.value));
        assert (!node.evaluated) : "Node " + node + " is filtered for the 2nd time already!";
        node.evaluated = true;
        this.logger.debug("Computing solutions for ({})-Node {} with {} children.", new Object[]{node.type, node.node, this.graph.getSuccessors((Object)node).size()});
        if (this.graph.getSuccessors((Object)node).isEmpty()) {
            EvaluatedGraph evaluatedGraph = new EvaluatedGraph();
            Graph subGraph = new Graph();
            subGraph.addItem(node.node);
            evaluatedGraph.graph = subGraph;
            evaluatedGraph.value = this.evaluator.evaluate((Object)subGraph);
            filteredSolutions.add(evaluatedGraph);
            this.logger.debug("Returning one single-node solution graph for leaf node {}", node.node);
            return filteredSolutions;
        }
        HashMap<InnerNodeLabel, Queue<EvaluatedGraph>> subSolutions = new HashMap<InnerNodeLabel, Queue<EvaluatedGraph>>();
        this.logger.debug("Computing subsolutions of node {}", (Object)node);
        for (InnerNodeLabel innerNodeLabel : this.graph.getSuccessors((Object)node)) {
            Queue<EvaluatedGraph> filteredSolutionsUnderChild = this.filterNodeSolution(innerNodeLabel);
            if (filteredSolutionsUnderChild.isEmpty()) {
                this.logger.info("Canceling further examinations as we have a node without sub-solutions.");
                return new LinkedList<EvaluatedGraph>();
            }
            subSolutions.put(innerNodeLabel, filteredSolutionsUnderChild);
            if (!this.logger.isDebugEnabled()) continue;
            StringBuilder sb = new StringBuilder();
            ((Queue)subSolutions.get(innerNodeLabel)).forEach(l -> sb.append("\n\tGraph Evaluation: " + l.value + "\n\tGraph representation: \n" + l.graph.getLineBasedStringRepresentation(2).replaceAll("\n", "\n\t\t")));
            this.logger.debug("Child {} has {} solutions: {}", new Object[]{innerNodeLabel, filteredSolutionsUnderChild.size(), sb});
        }
        if (node.type == NodeType.AND) {
            List subSolutionCombination2;
            int k = (int)Math.ceil(Math.pow(this.nodeLimit, 1.0f / (float)subSolutions.size()));
            ArrayList arrayList = new ArrayList();
            for (Queue child : subSolutions.values()) {
                ArrayList<EvaluatedGraph> bestSubSolutionsOfThisChild = new ArrayList<EvaluatedGraph>();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding {}/{} subsolutions of child into the cartesian product input.", (Object)Math.min(k, child.size()), (Object)child.size());
                }
                for (int i = 0; i < k; ++i) {
                    EvaluatedGraph subsolution = (EvaluatedGraph)child.poll();
                    if (subsolution == null) continue;
                    bestSubSolutionsOfThisChild.add(subsolution);
                }
                arrayList.add(bestSubSolutionsOfThisChild);
            }
            int i = 0;
            LDSRelationComputer cartesianProductBuilder = new LDSRelationComputer(new RelationComputationProblem(arrayList, subSolutionCombination -> {
                boolean validSolution;
                EvaluatedGraph extendedSolutionBase = new EvaluatedGraph();
                extendedSolutionBase.graph = new Graph();
                extendedSolutionBase.graph.addItem(node.node);
                for (EvaluatedGraph subSolution : subSolutionCombination) {
                    assert (subSolution != null);
                    extendedSolutionBase.graph.addGraph(subSolution.graph);
                    extendedSolutionBase.graph.addEdge(node.node, subSolution.graph.getRoot());
                }
                try {
                    extendedSolutionBase.value = this.evaluator.evaluate(extendedSolutionBase.graph);
                }
                catch (ObjectEvaluationFailedException e) {
                    this.logger.warn("Received exception {}.", (Throwable)e);
                }
                catch (InterruptedException e) {
                    assert (!Thread.currentThread().isInterrupted()) : "The interrupted-flag should not be true when an InterruptedException is thrown!";
                    this.logger.info("Thread was interrupted, cannot process this exception here, so reinterrupting the thread.");
                    Thread.currentThread().interrupt();
                }
                boolean isDouble = extendedSolutionBase.value instanceof Double;
                boolean bl = isDouble ? !extendedSolutionBase.value.equals(Double.NaN) : (validSolution = extendedSolutionBase.value != null);
                if (!validSolution && this.logger.isDebugEnabled()) {
                    this.logger.debug("\tCutting of sub-solution combination at level {}/{} as cost function returned {}. The following combined solution graph was subject of evaluation (one path per line, ommitted nodes are equal to the above line(s)):\n{}", new Object[]{subSolutionCombination.size(), subSolutionsPerChild.size(), extendedSolutionBase.value, extendedSolutionBase.graph.getLineBasedStringRepresentation(2)});
                }
                return validSolution;
            }));
            while ((subSolutionCombination2 = cartesianProductBuilder.nextTuple()) != null && i++ < 2 * this.nodeLimit) {
                EvaluatedGraph extendedSolutionBase = new EvaluatedGraph();
                extendedSolutionBase.graph = new Graph();
                extendedSolutionBase.graph.addItem(node.node);
                for (EvaluatedGraph subSolution : subSolutionCombination2) {
                    assert (subSolution != null);
                    extendedSolutionBase.graph.addGraph(subSolution.graph);
                    extendedSolutionBase.graph.addEdge(node.node, subSolution.graph.getRoot());
                }
                extendedSolutionBase.value = this.evaluator.evaluate(extendedSolutionBase.graph);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Combination {} of subsolutions with performances {} yields an aggregate performance value of {}", new Object[]{i, subSolutionCombination2.stream().map(g -> "" + g.value).collect(Collectors.joining(", ")), extendedSolutionBase.value});
                }
                filteredSolutions.add(extendedSolutionBase);
            }
            this.logger.trace("Determined {} sub-solutions for AND-node with {} children.", (Object)filteredSolutions.size(), (Object)subSolutions.size());
        } else {
            this.logger.debug("OR-Node: Selecting best child solution out of {}", (Object)subSolutions.size());
            for (Map.Entry entry : subSolutions.entrySet()) {
                this.logger.trace("Child {} has {} sub-solutions.", entry.getKey(), (Object)((Queue)entry.getValue()).size());
                for (EvaluatedGraph solutionBase : (Queue)entry.getValue()) {
                    EvaluatedGraph extendedSolutionBase = new EvaluatedGraph();
                    extendedSolutionBase.graph = new Graph(solutionBase.graph);
                    extendedSolutionBase.graph.addItem(node.node);
                    extendedSolutionBase.graph.addEdge(node.node, ((InnerNodeLabel)entry.getKey()).node);
                    extendedSolutionBase.value = solutionBase.value;
                    filteredSolutions.add(extendedSolutionBase);
                }
            }
        }
        filteredSolutions = new LinkedList(filteredSolutions.stream().sorted((g1, g2) -> g1.value.compareTo(g2.value)).limit(this.nodeLimit).collect(Collectors.toList()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} accepted sub-solutions of {}-node {} with {} children.", new Object[]{filteredSolutions.size(), node.type, node.path(), subSolutions.size()});
        }
        int i = 1;
        for (EvaluatedGraph g3 : filteredSolutions) {
            this.logger.debug("\tValue of sub-solution #{}: {}", (Object)i, g3.value);
            ++i;
        }
        return filteredSolutions;
    }

    public Graph<N> call() throws AlgorithmTimeoutedException, InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.bestSolutionBase;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.evaluator instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.evaluator).setLoggerName(name + ".eval");
        }
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    @Override
    public GraphGenerator<N, A> getGraphGenerator() {
        return ((GraphSearchInput)this.getInput()).getGraphGenerator();
    }

    class EvaluatedGraph {
        Graph<N> graph;
        V value;

        EvaluatedGraph() {
        }
    }

    public class InnerNodeLabel {
        InnerNodeLabel parent;
        int val;
        N node;
        NodeType type;
        boolean evaluated;

        public InnerNodeLabel(N node, NodeType type) {
            this.node = node;
            this.type = type;
        }

        public String path() {
            if (this.parent == null) {
                return this.val + "";
            }
            return this.parent.path() + " -> " + this.val;
        }
    }
}

