/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.auxilliary.iteratingoptimizer;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import com.google.common.eventbus.Subscribe;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.core.interfaces.IGraphSearch;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;

public class IteratingGraphSearchOptimizer<I extends GraphSearchWithPathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private final IGraphSearch<GraphSearchInput<N, A>, SearchGraphPath<N, A>, N, A> baseAlgorithm;

    public IteratingGraphSearchOptimizer(I problem, IGraphSearch<GraphSearchInput<N, A>, SearchGraphPath<N, A>, N, A> baseAlgorithm) {
        super(problem);
        this.baseAlgorithm = baseAlgorithm;
        baseAlgorithm.registerListener(new Object(){

            @Subscribe
            public void receiveEvent(AlgorithmEvent e) {
                IteratingGraphSearchOptimizer.this.post(e);
            }
        });
    }

    public boolean hasNext() {
        return this.baseAlgorithm.hasNext();
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        AlgorithmEvent parentEvent = this.baseAlgorithm.nextWithException();
        if (parentEvent instanceof GraphSearchSolutionCandidateFoundEvent) {
            try {
                SearchGraphPath path = (SearchGraphPath)((GraphSearchSolutionCandidateFoundEvent)parentEvent).getSolutionCandidate();
                Comparable score = ((GraphSearchWithPathEvaluationsInput)this.getInput()).getPathEvaluator().evaluate((Object)path);
                EvaluatedSearchGraphPath evaluatedPath = new EvaluatedSearchGraphPath(path.getNodes(), path.getEdges(), score);
                this.updateBestSeenSolution(evaluatedPath);
                EvaluatedSearchSolutionCandidateFoundEvent event = new EvaluatedSearchSolutionCandidateFoundEvent(this.getId(), evaluatedPath);
                this.post((Object)event);
                return event;
            }
            catch (ObjectEvaluationFailedException e) {
                throw new AlgorithmException((Throwable)e, "Object evaluation failed");
            }
        }
        return parentEvent;
    }

    public IGraphSearch<GraphSearchInput<N, A>, SearchGraphPath<N, A>, N, A> getBaseAlgorithm() {
        return this.baseAlgorithm;
    }
}

