/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.awastar;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import com.google.common.eventbus.Subscribe;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.ICancelableNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallySolutionReportingNodeEvaluator;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.travesaltree.DefaultNodeComparator;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import jaicore.search.structure.graphgenerator.GoalTester;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.PathGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwaStarSearch<I extends GraphSearchWithSubpathEvaluationsInput<T, A, V>, T, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, T, A, V> {
    private Logger logger = LoggerFactory.getLogger(AwaStarSearch.class);
    private String loggerName;
    private final SingleRootGenerator<T> rootNodeGenerator;
    private final SuccessorGenerator<T, A> successorGenerator;
    private final GoalTester<T> goalTester;
    private final INodeEvaluator<T, V> nodeEvaluator;
    private final Queue<Node<T, V>> closedList;
    private final Queue<Node<T, V>> suspendList;
    private final Queue<Node<T, V>> openList;
    private int currentLevel = -1;
    private int windowSize;
    private final List<EvaluatedSearchGraphPath<T, A, V>> unconfirmedSolutions = new ArrayList<EvaluatedSearchGraphPath<T, A, V>>();
    private final List<EvaluatedSearchSolutionCandidateFoundEvent<T, A, V>> unreturnedSolutionEvents = new ArrayList<EvaluatedSearchSolutionCandidateFoundEvent<T, A, V>>();

    public AwaStarSearch(I problem) {
        super(problem);
        this.rootNodeGenerator = (SingleRootGenerator)((GraphSearchInput)problem).getGraphGenerator().getRootGenerator();
        this.successorGenerator = ((GraphSearchInput)problem).getGraphGenerator().getSuccessorGenerator();
        this.goalTester = ((GraphSearchInput)problem).getGraphGenerator().getGoalTester();
        this.nodeEvaluator = ((GraphSearchWithSubpathEvaluationsInput)problem).getNodeEvaluator();
        this.closedList = new PriorityQueue<Node<T, V>>(new DefaultNodeComparator());
        this.suspendList = new PriorityQueue<Node<T, V>>(new DefaultNodeComparator());
        this.openList = new PriorityQueue<Node<T, V>>(new DefaultNodeComparator());
        this.windowSize = 0;
        if (this.nodeEvaluator instanceof IPotentiallySolutionReportingNodeEvaluator) {
            ((IPotentiallySolutionReportingNodeEvaluator)this.nodeEvaluator).registerSolutionListener(this);
        }
    }

    private void windowAStar() throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException {
        while (!this.openList.isEmpty()) {
            int nLevel;
            this.checkAndConductTermination();
            if (!this.unreturnedSolutionEvents.isEmpty()) {
                this.logger.info("Not doing anything because there are still unreturned solutions.");
                return;
            }
            Node<T, V> n = this.openList.peek();
            this.openList.remove(n);
            this.closedList.add(n);
            if (!n.isGoal()) {
                this.post(new NodeTypeSwitchEvent(this.getId(), n, "or_closed"));
            }
            if ((nLevel = n.externalPath().size() - 1) <= this.currentLevel - this.windowSize) {
                this.closedList.remove(n);
                this.suspendList.add(n);
                this.logger.info("Suspending node {} with level {}, which is lower than {}", new Object[]{n, nLevel, this.currentLevel - this.windowSize});
                this.post(new NodeTypeSwitchEvent(this.getId(), n, "or_suspended"));
                continue;
            }
            if (nLevel > this.currentLevel) {
                this.logger.info("Switching level from {} to {}", (Object)this.currentLevel, (Object)nLevel);
                this.currentLevel = nLevel;
            }
            this.checkAndConductTermination();
            this.logger.debug("Expanding {}. Starting successor generation.", n.getPoint());
            Collection successors = (Collection)this.computeTimeoutAware(() -> this.successorGenerator.generateSuccessors(n.getPoint()), "Successor generation timeouted", true);
            this.logger.debug("Successor generation finished. Identified {} successors.", (Object)successors.size());
            for (NodeExpansionDescription expansionDescription : successors) {
                V oldScore;
                this.checkAndConductTermination();
                Node<T, V> nPrime = new Node<T, V>(n, expansionDescription.getTo());
                if (this.goalTester instanceof NodeGoalTester) {
                    nPrime.setGoal(((NodeGoalTester)this.goalTester).isGoal(nPrime.getPoint()));
                } else if (this.goalTester instanceof PathGoalTester) {
                    nPrime.setGoal(((PathGoalTester)this.goalTester).isGoal(nPrime.externalPath()));
                }
                V nPrimeScore = this.nodeEvaluator.f(nPrime);
                if (nPrimeScore == null) {
                    this.logger.debug("Discarding node {} for which no f-value could be computed.", nPrime);
                    continue;
                }
                if (nPrime.isGoal()) {
                    List<T> newSolution = nPrime.externalPath();
                    EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(newSolution, null, nPrimeScore);
                    this.registerNewSolutionCandidate(solution);
                }
                if (!(this.openList.contains(nPrime) || this.closedList.contains(nPrime) || this.suspendList.contains(nPrime))) {
                    nPrime.setParent(n);
                    nPrime.setInternalLabel(nPrimeScore);
                    if (!nPrime.isGoal()) {
                        this.openList.add(nPrime);
                    }
                    this.post(new NodeAddedEvent(this.getId(), n, nPrime, nPrime.isGoal() ? "or_solution" : "or_open"));
                    continue;
                }
                if (this.openList.contains(nPrime) || this.suspendList.contains(nPrime)) {
                    oldScore = nPrime.getInternalLabel();
                    if (oldScore == null || oldScore.compareTo(nPrimeScore) <= 0) continue;
                    nPrime.setParent(n);
                    nPrime.setInternalLabel(nPrimeScore);
                    continue;
                }
                if (!this.closedList.contains(nPrime)) continue;
                oldScore = nPrime.getInternalLabel();
                if (oldScore != null && oldScore.compareTo(nPrimeScore) > 0) {
                    nPrime.setParent(n);
                    nPrime.setInternalLabel(nPrimeScore);
                }
                if (nPrime.isGoal()) continue;
                this.openList.add(nPrime);
            }
        }
    }

    @Subscribe
    public void receiveSolutionEvent(EvaluatedSearchSolutionCandidateFoundEvent<T, A, V> solutionEvent) {
        this.registerNewSolutionCandidate((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
        this.unconfirmedSolutions.add((EvaluatedSearchGraphPath<T, A, V>)solutionEvent.getSolutionCandidate());
    }

    public EvaluatedSearchSolutionCandidateFoundEvent<T, A, V> registerNewSolutionCandidate(EvaluatedSearchGraphPath<T, A, V> solution) {
        EvaluatedSearchSolutionCandidateFoundEvent<T, A, V> event = this.registerSolution(solution);
        this.unreturnedSolutionEvents.add(event);
        return event;
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            this.logger.debug("Next step in {}. State is {}", (Object)this.getId(), (Object)this.getState());
            this.checkAndConductTermination();
            switch (this.getState()) {
                case created: {
                    T externalRootNode = this.rootNodeGenerator.getRoot();
                    Node<T, V> rootNode = new Node<T, V>(null, externalRootNode);
                    this.logger.info("Initializing graph and OPEN with {}.", rootNode);
                    this.openList.add(rootNode);
                    this.post(new GraphInitializedEvent(this.getId(), rootNode));
                    rootNode.setInternalLabel(this.nodeEvaluator.f(rootNode));
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case active: {
                    this.logger.info("Searching for next solution.");
                    while (this.unreturnedSolutionEvents.isEmpty()) {
                        this.checkAndConductTermination();
                        if (this.openList.isEmpty()) {
                            if (this.suspendList.isEmpty()) {
                                this.logger.info("The whole graph has been exhausted. No more solutions can be found!");
                                AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                                return algorithmFinishedEvent;
                            }
                            this.logger.info("Search with window size {} is exhausted. Reactivating {} suspended nodes and incrementing window size.", (Object)this.windowSize, (Object)this.suspendList.size());
                            this.openList.addAll(this.suspendList);
                            this.suspendList.clear();
                            ++this.windowSize;
                            this.currentLevel = -1;
                        }
                        this.logger.info("Running core algorithm with window size {} and current level {}. {} items are in OPEN", new Object[]{this.windowSize, this.currentLevel, this.openList.size()});
                        this.windowAStar();
                    }
                    AlgorithmEvent event = (AlgorithmEvent)this.unreturnedSolutionEvents.get(0);
                    this.unreturnedSolutionEvents.remove(0);
                    if (!(event instanceof GraphSearchSolutionCandidateFoundEvent)) {
                        this.post(event);
                    }
                    AlgorithmEvent algorithmEvent = event;
                    return algorithmEvent;
                }
            }
            throw new IllegalStateException("Cannot do anything in state " + this.getState());
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    protected void shutdown() {
        if (this.isShutdownInitialized()) {
            return;
        }
        this.logger.info("Invoking shutdown routine ...");
        super.shutdown();
        if (this.nodeEvaluator instanceof ICancelableNodeEvaluator) {
            this.logger.info("Canceling node evaluator.");
            ((ICancelableNodeEvaluator)((Object)this.nodeEvaluator)).cancelActiveTasks();
        }
    }

    public void setNumCPUs(int numberOfCPUs) {
        this.logger.warn("Currently no support for parallelization");
    }

    public int getNumCPUs() {
        return 1;
    }

    @Override
    public GraphGenerator<T, A> getGraphGenerator() {
        return ((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getGraphGenerator();
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }
}

