/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AAlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeParentSwitchEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeRemovedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.interrupt.InterruptionTimerTask;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.google.common.eventbus.Subscribe;
import jaicore.search.algorithms.standard.bestfirst.IBestFirstConfig;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeAnnotationEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionJobSubmittedEvent;
import jaicore.search.algorithms.standard.bestfirst.events.RemovedGoalNodeFromOpenEvent;
import jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import jaicore.search.algorithms.standard.bestfirst.events.SolutionAnnotationEvent;
import jaicore.search.algorithms.standard.bestfirst.events.SuccessorComputationCompletedEvent;
import jaicore.search.algorithms.standard.bestfirst.exceptions.ControlledNodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.DecoratingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.ICancelableNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyGraphDependentNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallySolutionReportingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyUncertaintyAnnotatingNodeEvaluator;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import jaicore.search.structure.graphgenerator.MultipleRootGenerator;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.PathGoalTester;
import jaicore.search.structure.graphgenerator.RootGenerator;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirst<I extends GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private Logger logger = LoggerFactory.getLogger(BestFirst.class);
    private String loggerName;
    private static final String SPACER = "\n\t\t";
    protected final GraphGenerator<N, A> graphGenerator;
    protected final RootGenerator<N> rootGenerator;
    protected final SuccessorGenerator<N, A> successorGenerator;
    protected final PathGoalTester<N> pathGoalTester;
    protected final NodeGoalTester<N> nodeGoalTester;
    protected final INodeEvaluator<N, V> nodeEvaluator;
    private int timeoutForComputationOfF;
    private INodeEvaluator<N, V> timeoutNodeEvaluator;
    protected final boolean checkGoalPropertyOnEntirePath;
    private final boolean solutionReportingNodeEvaluator;
    private final boolean cancelableNodeEvaluator;
    private int createdCounter;
    private int expandedCounter;
    private boolean initialized = false;
    private final List<NodeExpansionDescription<N, A>> lastExpansion = new ArrayList<NodeExpansionDescription<N, A>>();
    protected final Queue<EvaluatedSearchGraphPath<N, A, V>> solutions = new LinkedBlockingQueue<EvaluatedSearchGraphPath<N, A, V>>();
    protected final Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> pendingSolutionFoundEvents = new LinkedBlockingQueue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>>();
    protected final Map<N, Node<N, V>> ext2int = new ConcurrentHashMap<N, Node<N, V>>();
    protected Queue<Node<N, V>> open = new PriorityQueue<Node<N, V>>((n1, n2) -> n1.getInternalLabel().compareTo(n2.getInternalLabel()));
    private Node<N, V> nodeSelectedForExpansion;
    private final Map<N, Thread> expanding = new HashMap<N, Thread>();
    private final Set<N> closed = new HashSet<N>();
    protected int additionalThreadsForNodeAttachment = 0;
    private ExecutorService pool;
    private Collection<Thread> threadsOfPool = new ArrayList<Thread>();
    protected final AtomicInteger activeJobs = new AtomicInteger(0);
    private final Lock activeJobsCounterLock = new ReentrantLock();
    private final Lock openLock = new ReentrantLock();
    private final Lock nodeSelectionLock = new ReentrantLock(true);
    private final Condition numberOfActiveJobsHasChanged = this.activeJobsCounterLock.newCondition();

    public BestFirst(I problem) {
        this((IBestFirstConfig)ConfigFactory.create(IBestFirstConfig.class, (Map[])new Map[0]), problem);
    }

    public BestFirst(IBestFirstConfig config, I problem) {
        super(config, problem);
        this.graphGenerator = ((GraphSearchInput)problem).getGraphGenerator();
        this.rootGenerator = this.graphGenerator.getRootGenerator();
        this.successorGenerator = this.graphGenerator.getSuccessorGenerator();
        boolean bl = this.checkGoalPropertyOnEntirePath = !(this.graphGenerator.getGoalTester() instanceof NodeGoalTester);
        if (this.checkGoalPropertyOnEntirePath) {
            this.nodeGoalTester = null;
            this.pathGoalTester = (PathGoalTester)this.graphGenerator.getGoalTester();
        } else {
            this.nodeGoalTester = (NodeGoalTester)this.graphGenerator.getGoalTester();
            this.pathGoalTester = null;
        }
        this.nodeEvaluator = ((GraphSearchWithSubpathEvaluationsInput)problem).getNodeEvaluator();
        if (this.nodeEvaluator == null) {
            throw new IllegalArgumentException("Cannot work with node evaulator that is null");
        }
        if (this.nodeEvaluator instanceof DecoratingNodeEvaluator) {
            DecoratingNodeEvaluator castedEvaluator = (DecoratingNodeEvaluator)this.nodeEvaluator;
            if (castedEvaluator.requiresGraphGenerator()) {
                this.logger.info("{} is a graph dependent node evaluator. Setting its graph generator now ...", (Object)castedEvaluator);
                castedEvaluator.setGenerator(this.graphGenerator);
            }
            if (castedEvaluator.reportsSolutions()) {
                this.logger.info("{} is a solution reporter. Register the search algo in its event bus", (Object)castedEvaluator);
                castedEvaluator.registerSolutionListener(this);
                this.solutionReportingNodeEvaluator = true;
            } else {
                this.solutionReportingNodeEvaluator = false;
            }
        } else {
            if (this.nodeEvaluator instanceof IPotentiallyGraphDependentNodeEvaluator) {
                this.logger.info("{} is a graph dependent node evaluator. Setting its graph generator now ...", this.nodeEvaluator);
                ((IPotentiallyGraphDependentNodeEvaluator)this.nodeEvaluator).setGenerator(this.graphGenerator);
            }
            if (this.nodeEvaluator instanceof IPotentiallySolutionReportingNodeEvaluator) {
                this.logger.info("{} is a solution reporter. Register the search algo in its event bus", this.nodeEvaluator);
                ((IPotentiallySolutionReportingNodeEvaluator)this.nodeEvaluator).registerSolutionListener(this);
                this.solutionReportingNodeEvaluator = true;
            } else {
                this.solutionReportingNodeEvaluator = false;
            }
        }
        this.cancelableNodeEvaluator = this.nodeEvaluator instanceof ICancelableNodeEvaluator;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.cancel(), "Shutdown hook thread for " + this));
    }

    protected Node<N, V> newNode(Node<N, V> parent, N t2) throws InterruptedException {
        return this.newNode(parent, t2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<N, V> newNode(Node<N, V> parent, N t2, V evaluation) throws InterruptedException {
        this.openLock.lockInterruptibly();
        try {
            assert (!this.open.contains(parent)) : "Parent node " + parent + " is still on OPEN, which must not be the case! OPEN class: " + this.open.getClass().getName() + ". OPEN size: " + this.open.size();
        }
        finally {
            this.openLock.unlock();
        }
        Node<N, V> newNode = new Node<N, V>(parent, t2);
        if (evaluation != null) {
            newNode.setInternalLabel(evaluation);
        }
        assert (parent == null || !parent.externalPath().contains(t2)) : "There is a loop in the underlying graph. The following path contains the last node twice: " + newNode.externalPath().stream().map(Object::toString).reduce("", (s, t) -> s + SPACER + t);
        assert (!this.ext2int.containsKey(t2)) : "Reached node " + t2 + " for the second time.\nt\tFirst path:" + this.ext2int.get(t2).externalPath().stream().map(n -> n + "").reduce("", (s, t) -> s + SPACER + t) + "\n\tSecond Path:" + newNode.externalPath().stream().map(Object::toString).reduce("", (s, t) -> s + SPACER + t);
        this.ext2int.put(t2, newNode);
        if (this.checkGoalPropertyOnEntirePath ? this.pathGoalTester.isGoal(newNode.externalPath()) : this.nodeGoalTester.isGoal(newNode.getPoint())) {
            newNode.setGoal(true);
        }
        if (parent == null) {
            this.post(new GraphInitializedEvent(this.getId(), newNode));
        } else {
            this.post(new NodeAddedEvent(this.getId(), parent, newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_CREATED.toString()));
            this.logger.debug("Sent message for creation of node {} as a successor of {}", (Object)newNode.hashCode(), (Object)parent.hashCode());
        }
        return newNode;
    }

    protected void labelNode(Node<N, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException {
        long fTime;
        this.logger.debug("Computing node label for node with hash code {}", (Object)node.hashCode());
        if (this.isStopCriterionSatisfied()) {
            this.logger.debug("Found stop criterion to be true. Returning control.");
            return;
        }
        InterruptionTimerTask interruptionTask = null;
        AtomicBoolean timedout = new AtomicBoolean(false);
        if (this.timeoutForComputationOfF > 0) {
            interruptionTask = new InterruptionTimerTask("Timeout for Node-Labeling in " + this, Thread.currentThread(), () -> timedout.set(true));
            this.logger.debug("Scheduling timeout for f-value computation. Allowed time: {}ms", (Object)this.timeoutForComputationOfF);
            GlobalTimer.getInstance().schedule((TimerTask)interruptionTask, (long)this.timeoutForComputationOfF);
        }
        Comparable label = null;
        boolean computationTimedout = false;
        long startComputation = System.currentTimeMillis();
        try {
            this.logger.trace("Calling f-function of node evaluator for {}", (Object)node.hashCode());
            label = (Comparable)this.computeTimeoutAware(() -> this.nodeEvaluator.f(node), "Node Labeling with " + this.nodeEvaluator, !this.threadsOfPool.contains(Thread.currentThread()));
            this.logger.trace("Determined f-value of {}", (Object)label);
            if (this.isStopCriterionSatisfied()) {
                return;
            }
            fTime = System.currentTimeMillis() - startComputation;
            if (this.timeoutForComputationOfF > 0 && fTime > (long)(this.timeoutForComputationOfF + 1000)) {
                this.logger.warn("Computation of f for node {} took {}ms, which is more than the allowed {}ms", new Object[]{node, fTime, this.timeoutForComputationOfF});
            }
        }
        catch (InterruptedException e) {
            this.logger.info("Thread {} received interrupt in node evaluation. Timeout flag is {}", (Object)Thread.currentThread(), (Object)timedout.get());
            if (timedout.get()) {
                this.logger.debug("Received interrupt during computation of f.");
                this.post(new NodeTypeSwitchEvent(this.getId(), node, ENodeType.OR_TIMEDOUT.toString()));
                node.setAnnotation(ENodeAnnotation.F_ERROR.toString(), "Timeout");
                computationTimedout = true;
                Thread.interrupted();
                try {
                    label = this.timeoutNodeEvaluator != null ? this.timeoutNodeEvaluator.f(node) : null;
                }
                catch (Exception e2) {
                    this.logger.error("An unexpected exception occurred while labeling node {}", node, (Object)e2);
                }
            }
            this.logger.info("Received external interrupt. Forwarding this interrupt.");
            throw e;
        }
        if (interruptionTask != null) {
            interruptionTask.cancel();
        }
        fTime = System.currentTimeMillis() - startComputation;
        node.setAnnotation(ENodeAnnotation.F_TIME.toString(), fTime);
        this.logger.debug("Computed label {} for {} in {}ms", new Object[]{label, node.hashCode(), fTime});
        if (label == null) {
            if (!computationTimedout) {
                this.logger.debug("Not inserting node {} since its label is missing!", (Object)node.hashCode());
            } else {
                this.logger.debug("Not inserting node {} because computation of f-value timed out.", (Object)node.hashCode());
            }
            if (!node.getAnnotations().containsKey(ENodeAnnotation.F_ERROR.toString())) {
                node.setAnnotation(ENodeAnnotation.F_ERROR.toString(), "f-computer returned NULL");
            }
            return;
        }
        assert (!(this.nodeEvaluator instanceof IPotentiallyUncertaintyAnnotatingNodeEvaluator) || !((IPotentiallyUncertaintyAnnotatingNodeEvaluator)this.nodeEvaluator).annotatesUncertainty() || node.getAnnotation("uncertainty") != null) : "Uncertainty-based node evaluator claims to annotate uncertainty but has not assigned any uncertainty to " + node.getPoint();
        node.setInternalLabel(label);
        assert (node.getInternalLabel() != null) : "Node label must not be NULL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initGraph() throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException {
        if (!this.initialized) {
            this.initialized = true;
            if (this.rootGenerator instanceof MultipleRootGenerator) {
                for (Object n0 : ((MultipleRootGenerator)this.rootGenerator).getRoots()) {
                    Node root = this.newNode(null, n0);
                    this.labelNode(root);
                    this.checkAndConductTermination();
                    this.openLock.lockInterruptibly();
                    try {
                        if (root == null) {
                            throw new IllegalArgumentException("Root for MultipleRootGenerator is null. Cannot add NULL as a node to OPEN");
                        }
                        this.open.add(root);
                    }
                    finally {
                        this.openLock.unlock();
                    }
                    this.logger.debug("Labeled root with {}", root.getInternalLabel());
                }
            } else {
                Node root = this.newNode(null, ((SingleRootGenerator)this.rootGenerator).getRoot());
                if (root == null) {
                    throw new IllegalArgumentException("Root for SingleRootGenerator is null. Cannot add NULL as a node to OPEN");
                }
                this.labelNode(root);
                this.checkAndConductTermination();
                if (root.getInternalLabel() == null) {
                    throw new IllegalArgumentException("The node evaluator has assigned NULL to the root node, which impedes an initialization of the search graph. Node evaluator: " + this.nodeEvaluator);
                }
                this.openLock.lockInterruptibly();
                try {
                    this.open.add(root);
                }
                finally {
                    this.openLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNodeForNextExpansion(Node<N, V> node) throws InterruptedException {
        assert (node != null) : "Cannot select node NULL for expansion!";
        this.nodeSelectionLock.lockInterruptibly();
        try {
            this.openLock.lockInterruptibly();
            try {
                assert (!this.open.contains(null)) : "OPEN contains NULL";
                assert (this.open.stream().noneMatch(n -> n.getInternalLabel() == null)) : "OPEN contains an element with value NULL";
                int openSizeBefore = this.open.size();
                assert (this.nodeSelectedForExpansion == null) : "Node selected for expansion must be NULL when setting it!";
                this.nodeSelectedForExpansion = node;
                assert (this.open.contains(node)) : "OPEN must contain the node to be expanded.\n\tOPEN size: " + this.open.size() + "\n\tNode to be expanded: " + node + ".\n\tOPEN: " + this.open.stream().map(n -> SPACER + n).collect(Collectors.joining());
                this.open.remove(this.nodeSelectedForExpansion);
                int openSizeAfter = this.open.size();
                assert (this.ext2int.containsKey(this.nodeSelectedForExpansion.getPoint())) : "A node chosen for expansion has no entry in the ext2int map!";
                assert (openSizeAfter == openSizeBefore - 1) : "OPEN size must descrease by one when selecting node for expansion";
            }
            finally {
                this.openLock.unlock();
            }
        }
        finally {
            this.nodeSelectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AlgorithmEvent expandNextNode() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        AAlgorithmEvent expansionEvent;
        assert (this.additionalThreadsForNodeAttachment == 0 || this.activeJobs.get() < this.additionalThreadsForNodeAttachment) : "Cannot expand nodes if number of active jobs (" + this.activeJobs.get() + " is at least as high as the threads available for node attachment (" + this.additionalThreadsForNodeAttachment + ")";
        long startTimeOfExpansion = System.currentTimeMillis();
        Node<N, V> tmpNodeSelectedForExpansion = null;
        this.nodeSelectionLock.lockInterruptibly();
        try {
            block45: {
                if (this.nodeSelectedForExpansion == null) {
                    this.activeJobsCounterLock.lockInterruptibly();
                    this.logger.trace("Acquired activeJobsCounterLock for read.");
                    boolean stopCriterionSatisfied = this.isStopCriterionSatisfied();
                    try {
                        this.logger.debug("No next node has been selected. Choosing the first from OPEN.");
                        while (this.open.isEmpty() && this.activeJobs.get() > 0 && !stopCriterionSatisfied) {
                            this.logger.trace("Await condition as open queue is empty and active jobs is {} ...", (Object)this.activeJobs.get());
                            this.numberOfActiveJobsHasChanged.await();
                            this.logger.trace("Got signaled");
                            stopCriterionSatisfied = this.isStopCriterionSatisfied();
                        }
                        if (stopCriterionSatisfied) break block45;
                        this.openLock.lock();
                        try {
                            if (this.open.isEmpty()) {
                                AlgorithmEvent algorithmEvent = null;
                                return algorithmEvent;
                            }
                            this.selectNodeForNextExpansion((N)this.open.peek());
                        }
                        finally {
                            this.openLock.unlock();
                        }
                    }
                    finally {
                        this.activeJobsCounterLock.unlock();
                        this.logger.trace("Released activeJobsCounterLock after read. Now checking termination.");
                        this.checkAndConductTermination();
                    }
                }
            }
            assert (this.nodeSelectedForExpansion != null) : "We have not selected any node for expansion, but this must be the case at this point.";
            tmpNodeSelectedForExpansion = this.nodeSelectedForExpansion;
            this.nodeSelectedForExpansion = null;
        }
        finally {
            this.nodeSelectionLock.unlock();
        }
        assert (this.nodeSelectedForExpansion == null) : "The object variable for the next selected node must be NULL at the end of the select step.";
        Node<N, V> actualNodeSelectedForExpansion = tmpNodeSelectedForExpansion;
        Map<N, Thread> stopCriterionSatisfied = this.expanding;
        synchronized (stopCriterionSatisfied) {
            this.expanding.put(actualNodeSelectedForExpansion.getPoint(), Thread.currentThread());
            assert (this.expanding.keySet().contains(tmpNodeSelectedForExpansion.getPoint())) : "The node selected for expansion should be in the EXPANDING map by now.";
        }
        assert (!this.open.contains(actualNodeSelectedForExpansion)) : "Node selected for expansion is still on OPEN";
        assert (actualNodeSelectedForExpansion != null) : "We have not selected any node for expansion, but this must be the case at this point.";
        this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
        if (!actualNodeSelectedForExpansion.isGoal()) {
            this.beforeExpansion(actualNodeSelectedForExpansion);
            this.post(new NodeTypeSwitchEvent(this.getId(), actualNodeSelectedForExpansion, "or_expanding"));
            this.logger.debug("Expanding node {} with f-value {}", (Object)actualNodeSelectedForExpansion.hashCode(), actualNodeSelectedForExpansion.getInternalLabel());
            this.logger.debug("Start computation of successors");
            List tmpSuccessorDescriptions = null;
            assert (!actualNodeSelectedForExpansion.isGoal()) : "Goal nodes must not be expanded!";
            tmpSuccessorDescriptions = (List)this.computeTimeoutAware(() -> {
                this.logger.trace("Invoking getSuccessors");
                return this.successorGenerator.generateSuccessors(actualNodeSelectedForExpansion.getPoint());
            }, "Successor generation", !this.threadsOfPool.contains(Thread.currentThread()));
            assert (tmpSuccessorDescriptions != null) : "Successor descriptions must never be null!";
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Received {} successor descriptions for node with hash code {}. The first 1000 of these are \n\t{}", new Object[]{tmpSuccessorDescriptions.size(), actualNodeSelectedForExpansion.getPoint(), tmpSuccessorDescriptions.stream().limit(1000L).map(s -> s.getTo().toString()).collect(Collectors.joining("\n\t"))});
            }
            List successorDescriptions = tmpSuccessorDescriptions;
            this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
            this.logger.debug("Finished computation of successors. Sending SuccessorComputationCompletedEvent with {} successors for {}", (Object)successorDescriptions.size(), (Object)actualNodeSelectedForExpansion.hashCode());
            this.post((Object)new SuccessorComputationCompletedEvent(this.getId(), actualNodeSelectedForExpansion, successorDescriptions));
            List todoList = successorDescriptions.stream().map(d -> d.getTo()).collect(Collectors.toList());
            long lastTerminationCheck = System.currentTimeMillis();
            for (NodeExpansionDescription successorDescription : successorDescriptions) {
                NodeBuilder nb = new NodeBuilder(todoList, actualNodeSelectedForExpansion, successorDescription);
                this.logger.trace("Number of additional threads for node attachment is {}", (Object)this.additionalThreadsForNodeAttachment);
                if (this.additionalThreadsForNodeAttachment < 1) {
                    nb.run();
                } else {
                    this.lockConditionSafeleyWhileExpandingNode(this.activeJobsCounterLock, actualNodeSelectedForExpansion);
                    this.logger.trace("Acquired activeJobsCounterLock for increment");
                    try {
                        this.activeJobs.incrementAndGet();
                    }
                    finally {
                        this.numberOfActiveJobsHasChanged.signalAll();
                        this.activeJobsCounterLock.unlock();
                        this.logger.trace("Released activeJobsCounterLock after increment");
                    }
                    if (this.isShutdownInitialized()) break;
                    this.pool.submit(nb);
                }
                if (System.currentTimeMillis() - lastTerminationCheck <= 50L) continue;
                if (this.expanding.containsKey(actualNodeSelectedForExpansion)) {
                    this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
                } else {
                    this.checkAndConductTermination();
                }
                lastTerminationCheck = System.currentTimeMillis();
            }
            this.logger.debug("Finished expansion of node {} after {}ms. Size of OPEN is now {}. Number of active jobs is {}", new Object[]{actualNodeSelectedForExpansion.hashCode(), System.currentTimeMillis() - startTimeOfExpansion, this.open.size(), this.activeJobs.get()});
            this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
            expansionEvent = new NodeExpansionJobSubmittedEvent(this.getId(), actualNodeSelectedForExpansion, successorDescriptions);
        } else {
            expansionEvent = new RemovedGoalNodeFromOpenEvent<N, V>(this.getId(), actualNodeSelectedForExpansion);
        }
        ++this.expandedCounter;
        Map<N, Thread> map = this.expanding;
        synchronized (map) {
            this.expanding.remove(actualNodeSelectedForExpansion.getPoint());
            assert (!this.expanding.containsKey(actualNodeSelectedForExpansion.getPoint())) : actualNodeSelectedForExpansion + " was expanded and it was not removed from EXPANDING!";
        }
        this.closed.add(actualNodeSelectedForExpansion.getPoint());
        assert (this.closed.contains(actualNodeSelectedForExpansion.getPoint())) : "Expanded node " + actualNodeSelectedForExpansion + " was not inserted into CLOSED!";
        this.post(new NodeTypeSwitchEvent(this.getId(), actualNodeSelectedForExpansion, ENodeType.OR_CLOSED.toString()));
        this.afterExpansion(actualNodeSelectedForExpansion);
        this.checkAndConductTermination();
        this.openLock.lockInterruptibly();
        try {
            this.logger.debug("Step ends. Size of OPEN now {}", (Object)this.open.size());
        }
        finally {
            this.openLock.unlock();
        }
        return expansionEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> registerSolution(EvaluatedSearchGraphPath<N, A, V> solutionPath) {
        EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent = super.registerSolution(solutionPath);
        assert (!this.solutions.contains(solutionEvent.getSolutionCandidate())) : "Registering solution " + solutionEvent.getSolutionCandidate() + " for the second time!";
        this.solutions.add((EvaluatedSearchGraphPath<N, A, V>)solutionEvent.getSolutionCandidate());
        Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> queue = this.pendingSolutionFoundEvents;
        synchronized (queue) {
            this.pendingSolutionFoundEvents.add(solutionEvent);
        }
        return solutionEvent;
    }

    private void lockConditionSafeleyWhileExpandingNode(Lock l, Node<N, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException {
        try {
            l.lockInterruptibly();
        }
        catch (InterruptedException e) {
            this.logger.debug("Received an interrupt while waiting for {} to become available.", (Object)l);
            Thread.currentThread().interrupt();
            this.checkTerminationAndUnregisterFromExpand(node);
        }
    }

    private void unregisterFromExpand(Node<N, V> node) {
        assert (this.expanding.containsKey(node.getPoint())) : "Cannot unregister a node that is not being expanded currently";
        assert (this.expanding.get(node.getPoint()) == Thread.currentThread()) : "Thread " + Thread.currentThread() + " cannot unregister other thread " + this.expanding.get(node.getPoint()) + " from expansion map!";
        this.logger.debug("Removing {} from EXPANDING.", (Object)node.hashCode());
        this.expanding.remove(node.getPoint());
    }

    private void checkTerminationAndUnregisterFromExpand(Node<N, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException {
        if (this.isStopCriterionSatisfied()) {
            this.unregisterFromExpand(node);
            assert (!this.expanding.containsKey(node.getPoint())) : "Expanded node " + this.nodeSelectedForExpansion + " was not removed from EXPANDING!";
        }
        super.checkAndConductTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.threadsOfPool.contains(Thread.currentThread())) {
            this.logger.error("Worker thread {} must not shutdown the algorithm!", (Object)Thread.currentThread());
        }
        assert (!Thread.currentThread().isInterrupted()) : "The thread should not be interrupted when shutdown is called.";
        if (this.isShutdownInitialized()) {
            return;
        }
        this.logger.info("Invoking shutdown routine ...");
        this.logger.debug("First conducting general algorithm shutdown routine ...");
        super.shutdown();
        this.logger.debug("General algorithm shutdown routine completed. Now conducting BestFirst-specific shutdown activities.");
        Map<N, Thread> map = this.expanding;
        synchronized (map) {
            int interruptedThreads = 0;
            for (Map.Entry<N, Thread> entry : this.expanding.entrySet()) {
                Thread t = entry.getValue();
                if (t.equals(Thread.currentThread())) {
                    this.expanding.remove(entry.getKey());
                    this.logger.debug("Removing node {} with thread {} from expansion map, since this thread is realizing the shutdown.", entry.getKey(), (Object)t);
                    continue;
                }
                if (!this.hasThreadBeenInterruptedDuringShutdown(t)) {
                    this.interruptThreadAsPartOfShutdown(t);
                    ++interruptedThreads;
                    continue;
                }
                this.logger.debug("Not interrupting thread {} again, since it already has been interrupted during shutdown.", (Object)t);
            }
            this.logger.debug("Interrupted {} active expansion threads.", (Object)interruptedThreads);
        }
        if (this.additionalThreadsForNodeAttachment > 0) {
            this.logger.debug("Shutting down worker pool.");
            if (this.pool != null) {
                this.logger.info("Triggering shutdown of builder thread pool with interrupt");
                this.pool.shutdownNow();
            }
            try {
                this.logger.debug("Waiting 3 days for pool shutdown.");
                if (this.pool != null) {
                    this.pool.awaitTermination(3L, TimeUnit.DAYS);
                } else {
                    this.logger.error("Apparently, the pool was unexpectedly not set and thus null.");
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Got interrupted during shutdown!", (Throwable)e);
            }
            if (this.pool != null) {
                assert (this.pool.isTerminated()) : "The worker pool has not been shutdown correctly!";
                if (!this.pool.isTerminated()) {
                    this.logger.error("Worker pool has not been shutdown correctly!");
                } else {
                    this.logger.info("Worker pool has been shut down.");
                }
            }
            this.logger.info("Setting number of active jobs to 0.");
            this.logger.trace("Waiting for activeJobsCounterLock.");
            this.activeJobsCounterLock.lock();
            try {
                this.logger.trace("Acquired activeJobsCounterLock for setting it to 0");
                this.activeJobs.set(0);
                this.numberOfActiveJobsHasChanged.signalAll();
            }
            finally {
                this.activeJobsCounterLock.unlock();
                this.logger.trace("Released activeJobsCounterLock after reset");
            }
            this.logger.debug("Pool shutdown completed.");
        } else {
            this.logger.debug("No additional threads for node attachment have been admitted, so there is no pool to close down.");
        }
        if (this.cancelableNodeEvaluator) {
            this.logger.info("Canceling node evaluator.");
            ((ICancelableNodeEvaluator)((Object)this.nodeEvaluator)).cancelActiveTasks();
        }
        this.logger.info("Shutdown completed");
    }

    @Subscribe
    public void receiveSolutionCandidateEvent(EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent) {
        try {
            this.logger.info("Received solution with f-value {} and annotations {}", ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getScore(), ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getAnnotations());
            this.registerSolution((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
        }
        catch (Exception e) {
            this.logger.error("An unexpected exception occurred while receiving EvaluatedSearchSolutionCandidateFoundEvent.", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveRolloutEvent(RolloutEvent<N, V> event) {
        try {
            this.logger.debug("Received rollout event: {}", event);
            this.post(event);
        }
        catch (Exception e) {
            this.logger.error("An unexpected exception occurred while receiving RolloutEvent", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveSolutionCandidateAnnotationEvent(SolutionAnnotationEvent<N, A, V> event) {
        try {
            this.logger.debug("Received solution annotation: {}", event);
            this.post(event);
        }
        catch (Exception e) {
            this.logger.error("An unexpected exception occurred receiveSolutionCandidateAnnotationEvent.", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveNodeAnnotationEvent(NodeAnnotationEvent<N> event) {
        try {
            N nodeExt = event.getNode();
            this.logger.debug("Received annotation {} with value {} for node {}", new Object[]{event.getAnnotationName(), event.getAnnotationValue(), event.getNode()});
            if (!this.ext2int.containsKey(nodeExt)) {
                throw new IllegalArgumentException("Received annotation for a node I don't know!");
            }
            Node<N, V> nodeInt = this.ext2int.get(nodeExt);
            nodeInt.setAnnotation(event.getAnnotationName(), event.getAnnotationValue());
        }
        catch (Exception e) {
            this.logger.error("An unexpected exception occurred while receiving node annotation event ", (Throwable)e);
        }
    }

    protected void insertNodeIntoLocalGraph(Node<N, V> node) throws InterruptedException {
        Node<N, V> localVersionOfParent = null;
        List<Node<N, V>> path = node.path();
        Node<N, V> leaf = path.get(path.size() - 1);
        for (Node<N, V> nodeOnPath : path) {
            if (!this.ext2int.containsKey(nodeOnPath.getPoint())) {
                assert (nodeOnPath.getParent() != null) : "Want to insert a new node that has no parent. That must not be the case! Affected node is: " + nodeOnPath.getPoint();
                assert (this.ext2int.containsKey(nodeOnPath.getParent().getPoint())) : "Want to insert a node whose parent is unknown locally";
                Node<N, V> newNode = this.newNode(localVersionOfParent, nodeOnPath.getPoint(), nodeOnPath.getInternalLabel());
                if (!newNode.isGoal() && !newNode.getPoint().equals(leaf.getPoint())) {
                    this.post(new NodeTypeSwitchEvent(this.getId(), newNode, "or_closed"));
                }
                localVersionOfParent = newNode;
                continue;
            }
            localVersionOfParent = this.getLocalVersionOfNode(nodeOnPath);
        }
    }

    protected Node<N, V> getLocalVersionOfNode(Node<N, V> node) {
        return this.ext2int.get(node.getPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(Collection<Node<N, V>> initialNodes) throws InterruptedException {
        if (this.initialized) {
            throw new UnsupportedOperationException("Bootstrapping is only supported if the search has already been initialized.");
        }
        try {
            this.initGraph();
        }
        catch (Exception e) {
            this.logger.error("An unexpected exception occurred while the graph should be initialized.", (Throwable)e);
            return;
        }
        this.openLock.lockInterruptibly();
        try {
            this.open.clear();
            for (Node<N, V> node : initialNodes) {
                this.insertNodeIntoLocalGraph(node);
                if (node == null) {
                    throw new IllegalArgumentException("Cannot add NULL as a node to OPEN");
                }
                if (node.getInternalLabel() == null) {
                    throw new IllegalArgumentException("Cannot insert node with label NULL");
                }
                this.open.add(this.getLocalVersionOfNode(node));
            }
        }
        finally {
            this.openLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            switch (this.getState()) {
                case created: {
                    AlgorithmInitializedEvent event = this.activate();
                    this.logger.info("Initializing BestFirst search {} with {} CPUs and a timeout of {}ms", new Object[]{this.getId(), this.getConfig().cpus(), this.getConfig().timeout()});
                    int additionalCPUs = this.getConfig().cpus() - 1;
                    if (additionalCPUs > 0) {
                        this.parallelizeNodeExpansion(additionalCPUs);
                    }
                    this.initGraph();
                    this.logger.info("Search initialized, returning activation event.");
                    AlgorithmInitializedEvent algorithmInitializedEvent = event;
                    return algorithmInitializedEvent;
                }
                case active: {
                    AlgorithmEvent event = this.pendingSolutionFoundEvents;
                    // MONITORENTER : event
                    if (!this.pendingSolutionFoundEvents.isEmpty()) {
                        AlgorithmEvent additionalCPUs = (AlgorithmEvent)this.pendingSolutionFoundEvents.poll();
                        // MONITOREXIT : event
                        return additionalCPUs;
                    }
                    // MONITOREXIT : event
                    if (this.additionalThreadsForNodeAttachment > 0) {
                        boolean poolSlotFree = false;
                        boolean haveLock = false;
                        do {
                            this.checkAndConductTermination();
                            try {
                                this.activeJobsCounterLock.lockInterruptibly();
                                haveLock = true;
                                this.logger.trace("Acquired activeJobsCounterLock for read");
                                this.logger.debug("The pool is currently busy with {}/{} jobs.", (Object)this.activeJobs.get(), (Object)this.additionalThreadsForNodeAttachment);
                                if (this.additionalThreadsForNodeAttachment > this.activeJobs.get()) {
                                    poolSlotFree = true;
                                }
                                this.logger.trace("Number of active jobs is now {}", (Object)this.activeJobs.get());
                                if (poolSlotFree) continue;
                                this.logger.trace("Releasing activeJobsCounterLock for a wait.");
                                try {
                                    haveLock = false;
                                    this.numberOfActiveJobsHasChanged.await();
                                    haveLock = true;
                                }
                                catch (InterruptedException e) {
                                    this.logger.debug("Received an interrupt while waiting for number of active jobs to change.");
                                    this.activeJobsCounterLock.unlock();
                                    Thread.currentThread().interrupt();
                                    this.checkAndConductTermination();
                                }
                                this.logger.trace("Re-acquired activeJobsCounterLock after a wait.");
                                this.logger.debug("Number of active jobs has changed. Let's see whether we can enter now ...");
                            }
                            finally {
                                if (haveLock) {
                                    this.logger.trace("Trying to unlock activeJobsCounterLock");
                                    this.activeJobsCounterLock.unlock();
                                    haveLock = false;
                                    this.logger.trace("Released activeJobsCounterLock after read.");
                                } else {
                                    this.logger.trace("Don't need to give lock free, because we came to the finally-block via an exception.");
                                }
                            }
                        } while (!poolSlotFree);
                    }
                    this.checkAndConductTermination();
                    event = this.expandNextNode();
                    if (event == null) {
                        Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> queue = this.pendingSolutionFoundEvents;
                        // MONITORENTER : queue
                        if (this.pendingSolutionFoundEvents.isEmpty()) {
                            this.logger.info("No event was returned and there are no pending solutions. Number of active jobs: {}. Setting state to inactive.", (Object)this.activeJobs.get());
                            AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                            // MONITOREXIT : queue
                            return algorithmFinishedEvent;
                        }
                        event = (AlgorithmEvent)this.pendingSolutionFoundEvents.poll();
                        // MONITOREXIT : queue
                    }
                    if (!(event instanceof SolutionCandidateFoundEvent)) {
                        this.post(event);
                    }
                    AlgorithmEvent algorithmEvent = event;
                    return algorithmEvent;
                }
            }
            throw new IllegalStateException("BestFirst search is in state " + this.getState() + " in which next must not be called!");
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    public void selectNodeForNextExpansion(N node) throws InterruptedException {
        this.selectNodeForNextExpansion((N)this.ext2int.get(node));
    }

    public NodeExpansionJobSubmittedEvent<N, A, V> nextNodeExpansion() {
        while (this.hasNext()) {
            AlgorithmEvent e = this.next();
            if (!(e instanceof NodeExpansionJobSubmittedEvent)) continue;
            return (NodeExpansionJobSubmittedEvent)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluatedSearchGraphPath<N, A, V> nextSolutionThatDominatesOpen() throws InterruptedException, AlgorithmExecutionCanceledException, TimeoutException, AlgorithmException {
        EvaluatedSearchGraphPath currentlyBestSolution = null;
        Object currentlyBestScore = null;
        boolean loopCondition = true;
        while (loopCondition) {
            EvaluatedSearchGraphPath solution = (EvaluatedSearchGraphPath)this.nextSolutionCandidate();
            Object scoreOfSolution = solution.getScore();
            if (currentlyBestScore == null || scoreOfSolution.compareTo(currentlyBestScore) < 0) {
                currentlyBestScore = scoreOfSolution;
                currentlyBestSolution = solution;
            }
            this.openLock.lockInterruptibly();
            try {
                loopCondition = this.open.peek().getInternalLabel().compareTo(currentlyBestScore) < 0;
            }
            finally {
                this.openLock.unlock();
            }
        }
        return currentlyBestSolution;
    }

    protected void afterInitialization() {
    }

    protected boolean beforeSelection() {
        return true;
    }

    protected void afterSelection(Node<N, V> node) {
    }

    protected void beforeExpansion(Node<N, V> node) {
    }

    protected void afterExpansion(Node<N, V> node) {
    }

    public List<N> getCurrentPathToNode(N node) {
        return this.ext2int.get(node).externalPath();
    }

    public INodeEvaluator<N, V> getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public int getAdditionalThreadsForExpansion() {
        return this.additionalThreadsForNodeAttachment;
    }

    private void parallelizeNodeExpansion(int threadsForExpansion) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("The number of additional threads can be only set once per search!");
        }
        if (threadsForExpansion < 1) {
            throw new IllegalArgumentException("Number of threads should be at least 1 for " + this.getClass().getName());
        }
        int threadsForAlgorithm = this.getConfig().threads() >= 0 ? this.getConfig().threads() : this.getConfig().cpus();
        this.additionalThreadsForNodeAttachment = threadsForExpansion;
        if (this.additionalThreadsForNodeAttachment > threadsForAlgorithm - 2) {
            this.additionalThreadsForNodeAttachment = Math.min(this.additionalThreadsForNodeAttachment, threadsForAlgorithm - 2);
        }
        if (this.additionalThreadsForNodeAttachment < 1) {
            this.logger.info("Effectively not parallelizing, since only {} threads are allowed by configuration, and 2 are needed for control and maintenance.", (Object)threadsForAlgorithm);
            this.additionalThreadsForNodeAttachment = 0;
            return;
        }
        AtomicInteger counter = new AtomicInteger(0);
        this.pool = Executors.newFixedThreadPool(this.additionalThreadsForNodeAttachment, r -> {
            Thread t = new Thread(r);
            t.setName("ORGraphSearch-worker-" + counter.incrementAndGet());
            this.threadsOfPool.add(t);
            return t;
        });
    }

    public int getTimeoutForComputationOfF() {
        return this.timeoutForComputationOfF;
    }

    public void setTimeoutForComputationOfF(int timeoutInMS, INodeEvaluator<N, V> timeoutEvaluator) {
        this.timeoutForComputationOfF = timeoutInMS;
        this.timeoutNodeEvaluator = timeoutEvaluator;
    }

    public List<Node<N, V>> getOpen() {
        return Collections.unmodifiableList(new ArrayList<Node<N, V>>(this.open));
    }

    public Node<N, V> getInternalRepresentationOf(N node) {
        return this.ext2int.get(node);
    }

    public void setOpen(Queue<Node<N, V>> collection) {
        this.openLock.lock();
        try {
            collection.clear();
            collection.addAll(this.open);
            this.open = collection;
        }
        finally {
            this.openLock.unlock();
        }
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.nodeEvaluator instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of node evaluator {} to {}.nodeevaluator", this.nodeEvaluator, (Object)name);
            ((ILoggingCustomizable)this.nodeEvaluator).setLoggerName(name + ".nodeevaluator");
        } else {
            this.logger.info("Node evaluator {} does not implement ILoggingCustomizable, so its logger won't be customized.", this.nodeEvaluator);
        }
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    public Queue<EvaluatedSearchGraphPath<N, A, V>> getSolutionQueue() {
        return this.solutions;
    }

    public int getExpandedCounter() {
        return this.expandedCounter;
    }

    public int getCreatedCounter() {
        return this.createdCounter;
    }

    public V getFValue(N node) {
        return this.getFValue(this.ext2int.get(node));
    }

    public V getFValue(Node<N, V> node) {
        return node.getInternalLabel();
    }

    public Map<String, Object> getNodeAnnotations(N node) {
        Node<N, V> intNode = this.ext2int.get(node);
        return intNode.getAnnotations();
    }

    public Object getNodeAnnotation(N node, String annotation) {
        Node<N, V> intNode = this.ext2int.get(node);
        return intNode.getAnnotation(annotation);
    }

    public IBestFirstConfig getConfig() {
        return (IBestFirstConfig)super.getConfig();
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("graphGenerator", this.graphGenerator);
        fields.put("nodeEvaluator", this.nodeEvaluator);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    private class NodeBuilder
    implements Runnable {
        private final Collection<N> todoList;
        private final Node<N, V> expandedNodeInternal;
        private final NodeExpansionDescription<N, A> successorDescription;

        public NodeBuilder(Collection<N> todoList, Node<N, V> expandedNodeInternal, NodeExpansionDescription<N, A> successorDescription) {
            this.todoList = todoList;
            this.expandedNodeInternal = expandedNodeInternal;
            this.successorDescription = successorDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void communicateJobFinished() {
            Collection collection = this.todoList;
            synchronized (collection) {
                this.todoList.remove(this.successorDescription.getTo());
                if (this.todoList.isEmpty()) {
                    BestFirst.this.post(new NodeExpansionCompletedEvent(BestFirst.this.getId(), this.expandedNodeInternal));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BestFirst.this.logger.debug("Start node creation.");
            long start = System.currentTimeMillis();
            try {
                Object existingIdenticalNodeOnOpen;
                Node newNode;
                block70: {
                    if (BestFirst.this.isStopCriterionSatisfied()) {
                        this.communicateJobFinished();
                        return;
                    }
                    BestFirst.this.lastExpansion.add(this.successorDescription);
                    newNode = BestFirst.this.newNode(this.expandedNodeInternal, this.successorDescription.getTo());
                    BestFirst.this.createdCounter++;
                    try {
                        BestFirst.this.labelNode(newNode);
                        if (newNode.getInternalLabel() != null) break block70;
                        BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, ENodeType.OR_PRUNED.toString()));
                        return;
                    }
                    catch (InterruptedException e) {
                        if (!BestFirst.this.isShutdownInitialized()) {
                            BestFirst.this.logger.warn("Leaving node building routine due to interrupt. This leaves the search inconsistent; the node should be attached again!");
                        }
                        BestFirst.this.logger.debug("Worker has been interrupted, exiting.");
                        BestFirst.this.post(new NodeAnnotationEvent(BestFirst.this.getId(), newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, ENodeType.OR_PRUNED.toString()));
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (TimeoutException e) {
                        BestFirst.this.logger.debug("Node evaluation of {} has timed out.", (Object)newNode.hashCode());
                        newNode.setAnnotation(ENodeAnnotation.F_ERROR.toString(), e);
                        BestFirst.this.post(new NodeAnnotationEvent(BestFirst.this.getId(), newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, ENodeType.OR_TIMEDOUT.toString()));
                        return;
                    }
                    catch (ControlledNodeEvaluationException e) {
                        BestFirst.this.logger.debug("Node evaluation failed with a controlled exception.");
                        newNode.setAnnotation(ENodeAnnotation.F_ERROR.toString(), (Object)e);
                        BestFirst.this.post(new NodeAnnotationEvent(BestFirst.this.getId(), newNode, ENodeAnnotation.F_ERROR.toString(), (Object)e));
                        BestFirst.this.post(new NodeAnnotationEvent(BestFirst.this.getId(), newNode, ENodeAnnotation.F_MESSAGE.toString(), "hello, yes it is pruned!"));
                        BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, ENodeType.OR_PRUNED.toString()));
                        return;
                    }
                    catch (Exception e) {
                        BestFirst.this.logger.debug("Observed an exception during computation of f:\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e));
                        newNode.setAnnotation(ENodeAnnotation.F_ERROR.toString(), e);
                        BestFirst.this.post(new NodeAnnotationEvent(BestFirst.this.getId(), newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, ENodeType.OR_PRUNED.toString()));
                        return;
                    }
                }
                if (BestFirst.this.isStopCriterionSatisfied()) {
                    this.communicateJobFinished();
                    return;
                }
                boolean nodeProcessed = false;
                if (BestFirst.this.getConfig().parentDiscarding() != ParentDiscarding.NONE) {
                    BestFirst.this.openLock.lockInterruptibly();
                    try {
                        Optional<Object> existingIdenticalNodeOnClosed;
                        existingIdenticalNodeOnOpen = BestFirst.this.open.stream().filter(n -> n.getPoint().equals(newNode.getPoint())).findFirst();
                        if (((Optional)existingIdenticalNodeOnOpen).isPresent()) {
                            Node existingNode = (Node)((Optional)existingIdenticalNodeOnOpen).get();
                            if (newNode.getInternalLabel().compareTo(existingNode.getInternalLabel()) < 0) {
                                BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_OPEN.toString()));
                                BestFirst.this.post(new NodeRemovedEvent(BestFirst.this.getId(), (Object)existingNode));
                                BestFirst.this.open.remove(existingNode);
                                if (newNode.getInternalLabel() == null) {
                                    throw new IllegalArgumentException("Cannot insert nodes with value NULL into OPEN!");
                                }
                                BestFirst.this.open.add(newNode);
                            } else {
                                BestFirst.this.post(new NodeRemovedEvent(BestFirst.this.getId(), newNode));
                            }
                            nodeProcessed = true;
                        } else if (BestFirst.this.getConfig().parentDiscarding() == ParentDiscarding.ALL && (existingIdenticalNodeOnClosed = BestFirst.this.closed.stream().filter(n -> n.equals(newNode.getPoint())).findFirst()).isPresent()) {
                            Node node2 = BestFirst.this.ext2int.get(existingIdenticalNodeOnClosed.get());
                            if (newNode.getInternalLabel().compareTo(node2.getInternalLabel()) < 0) {
                                node2.setParent(newNode.getParent());
                                node2.setInternalLabel(newNode.getInternalLabel());
                                BestFirst.this.closed.remove(node2.getPoint());
                                BestFirst.this.open.add(node2);
                                BestFirst.this.post(new NodeParentSwitchEvent(BestFirst.this.getId(), node2, node2.getParent(), newNode.getParent()));
                            }
                            BestFirst.this.post(new NodeRemovedEvent(BestFirst.this.getId(), newNode));
                            nodeProcessed = true;
                        }
                    }
                    finally {
                        BestFirst.this.openLock.unlock();
                    }
                }
                if (!nodeProcessed) {
                    if (!newNode.isGoal()) {
                        BestFirst.this.openLock.lockInterruptibly();
                        existingIdenticalNodeOnOpen = BestFirst.this.expanding;
                        synchronized (existingIdenticalNodeOnOpen) {
                            try {
                                assert (!BestFirst.this.closed.contains(newNode.getPoint())) : "Currently only tree search is supported. But now we add a node to OPEN whose point has already been expanded before.";
                                BestFirst.this.expanding.keySet().forEach(node -> {
                                    assert (!node.equals(newNode.getPoint())) : Thread.currentThread() + " cannot add node to OPEN that is currently being expanded by " + BestFirst.access$2100(BestFirst.this).get(node) + ".\n\tFrom: " + newNode.getParent().getPoint() + "\n\tTo: " + node;
                                });
                                if (newNode.getInternalLabel() == null) {
                                    throw new IllegalArgumentException("Cannot insert nodes with value NULL into OPEN!");
                                }
                                BestFirst.this.logger.debug("Inserting successor {} of {} to OPEN. F-Value is {}", new Object[]{newNode.hashCode(), this.expandedNodeInternal, newNode.getInternalLabel()});
                                BestFirst.this.open.add(newNode);
                            }
                            finally {
                                BestFirst.this.openLock.unlock();
                            }
                        }
                    }
                    BestFirst.this.post(new NodeTypeSwitchEvent(BestFirst.this.getId(), newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_OPEN.toString()));
                    BestFirst.this.createdCounter++;
                }
                if (newNode.isGoal()) {
                    EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(newNode.externalPath(), null, newNode.getInternalLabel());
                    if (!BestFirst.this.solutionReportingNodeEvaluator) {
                        BestFirst.this.registerSolution(solution);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                BestFirst.this.logger.info("Node builder has been interrupted, finishing execution.");
            }
            catch (Exception e) {
                BestFirst.this.logger.error("An unexpected exception occurred while building nodes", (Throwable)e);
            }
            finally {
                assert (!Thread.holdsLock(BestFirst.this.openLock)) : "Node Builder must not hold a lock on OPEN when locking the active jobs counter";
                BestFirst.this.logger.debug("Trying to decrement active jobs by one.");
                BestFirst.this.logger.trace("Waiting for activeJobsCounterlock to become free.");
                BestFirst.this.activeJobsCounterLock.lock();
                BestFirst.this.logger.trace("Acquired activeJobsCounterLock for decrement.");
                try {
                    if (BestFirst.this.pool != null) {
                        BestFirst.this.activeJobs.decrementAndGet();
                        BestFirst.this.logger.trace("Decremented job counter.");
                    }
                }
                finally {
                    BestFirst.this.numberOfActiveJobsHasChanged.signalAll();
                    BestFirst.this.activeJobsCounterLock.unlock();
                    BestFirst.this.logger.trace("Released activeJobsCounterLock after decrement.");
                }
                this.communicateJobFinished();
                BestFirst.this.logger.debug("Builder exits. Build process took {}ms. Interrupt-flag is {}", (Object)(System.currentTimeMillis() - start), (Object)Thread.currentThread().isInterrupted());
            }
        }
    }

    private static enum ENodeAnnotation {
        F_ERROR("fError"),
        F_MESSAGE("fMessage"),
        F_TIME("fTime");

        private String name;

        private ENodeAnnotation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum ENodeType {
        OR_PRUNED("or_pruned"),
        OR_TIMEDOUT("or_timedout"),
        OR_OPEN("or_open"),
        OR_SOLUTION("or_solution"),
        OR_CREATED("or_created"),
        OR_CLOSED("or_closed");

        private String name;

        private ENodeType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ParentDiscarding {
        NONE,
        OPEN,
        ALL;

    }
}

